;*****************************************************************************
;*                            PHASENANSCHNITT-STEUERUNG (TEST)               *
;*                              14.06.15                                     *
;*****************************************************************************

        LIST    P=12F675       
        TITLE   "PHASE-GALVANISCHE-TRENNUNG"

        ERRORLEVEL -302
        INCLUDE <P12F675.INC>

;AUTOMATISCHE BRENN-EINSTELLUNGEN FUERS BRENNPROGRAMM
__CONFIG _HS_OSC & _WDT_OFF & _PWRTE_OFF & _BODEN_ON & _MCLRE_OFF & _CPD_OFF & _CP_OFF


;------------------------- MACROS -----------------------------------------
;MAN BRAUCHT DANN NUR Z.B. SCHREIBEN BANK1 UND DIE BEFEHLE WERDEN AUSGEFUEHRT
;ALSO DEN WIEDERHOLENDEN TEXT BRAUCHT MAN NUR HIER OBEN EINMALIG SCHREIBEN

BANK0                   MACRO                   ;MACRO TO SELECT DATA RAM BANK 0
                        BCF     STATUS,RP0
                        ENDM
;----------------------------------------------------------------------------
BANK1                   MACRO                   ;MACRO TO SELECT DATA RAM BANK 1
                        BSF     STATUS,RP0
                        ENDM
;----------------------------------------------------------------------------
;FR INTERRUPT 
;----------------------------------------------------------------------------
PUSH                    MACRO
                        MOVWF   W_STACK
                        MOVF    STATUS, W
                        MOVWF   S_STACK
                        ENDM
;----------------------------------------------------------------------------
POP                     MACRO
                        MOVF    S_STACK, W
                        MOVWF   STATUS
                        SWAPF   W_STACK, F
                        SWAPF   W_STACK, W
                        ENDM
;----------------------------------------------------------------------------

;VARIABLEN
BIT0        EQU 0
BIT1        EQU 1
BIT2        EQU 2
BIT3        EQU 3
BIT4        EQU 4
BIT5        EQU 5
BIT6        EQU 6
BIT7        EQU 7

;--------------------------------------------------------------------------
;REGISTER ZUORDNEN NACH DEM DIE FESTEN-REGISTER ZU ENDE SIND
;ES GEHT ALSO ERST AB 22 HEX LOS
;DIES IST ALSO DIE RAM-SPEICHER ZUORDNUNG

ZAE                     EQU     0X22
ZEIT_L                  EQU     0X23
ZEIT_H                  EQU     0X24
HELP                    EQU     0X25
;BIT0 BEI HIGH --> NULLDURCHGANG WAR VORHANDEN

;---
;FUER INTERRUPT
S_STACK                 EQU     0X26
W_STACK                 EQU     0X27


;--------------------------------------------------------------------------


;SPEICHERANFANG BZW. BEGINN
    ORG 0X0000
    GOTO MAIN           ; SPRUNG ZUM HAUPTPROGRAMM
    ORG 0X0004
    GOTO INTERRUPT      ; BEI EINEM INTERRUPT SPRUNG ZU INTERRUPT-UNTERPROGRAMM


    ORG 0X0010
;*****************************************************************************
;*                            HAUPTPROGRAMM                                  *
;*                              26.12.13                                     *
;*****************************************************************************
;PORT-INITIALISIERUNG
MAIN                    BANK0
                        CLRF    GPIO     
                        MOVLW   0X07                        ;COMPARATORS ALLE AUS 
                        MOVWF   CMCON

                        BANK1
;INIT TIMER 0 FUER 10MSEC FUER ZEITSCHLEIFE 
;(HIER MUSS MAN IN DEM DATENBLATT (DATASHEET) BEI WWW.MICROCHIP.COM (EIN *.PDF-FILE) NACHSEHEN, WIE ALLES FUNKTIONIERT)
                        MOVLW   B'10000111'                 ;BIT0-2 111=PRESCALER256, BIT3 0=TMR0, BIT4 0=ENTFAELLT, BIT5 0=TAKT VOM SYSTEM, BIT6 0=KEIN RB-INTERRUPT, BIT7 1=PULL-UPS DISABLE 
                        MOVWF   OPTION_REG      

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                        CLRF    ANSEL                       ;AD ERST IN INTERRUPT EINGESTELLT / JETZT ALLES I/O
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                        MOVLW   B'11111011'                 ;GP2 ALS AUSGANG (ALSO HIER DIE 0), SONST ALLES EINGNGE (ALSO IMMER DIE (1))
                        MOVWF   TRISIO

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;INITIALISIERUNG--ZU--ENDE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                        BANK0
                        BCF     HELP, BIT0      ;AUF KEINEN NULLDURCHGANG AM ANFANG SETZEN
                        BCF     GPIO, GP2       ;OPTOKOPPLER LED AUS

                        MOVLW   D'50'           ;ZEITSCHLEIFE FUER 0,5SEC EINGESTELLT    50*10MSEC=500MSEC
                        CALL    ZS10MSEC        ;UM EINSCHALTIMPULSE ZU UNTERDRUECKEN

 ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;ERST NACH ZEITSCHLEIFE, SONST KOMMT INTERRUPT GLEICH AM ANFANG !!!!

;INTERRUPT ZULASSEN
                        BANK1
                        BSF     OPTION_REG, INTEDG  ;STEIGENDE FLANKE ZULASSEN / ALSO VON NULL AUF +5VOLT

;CHANGE AUF GP0
                        BSF     INTCON, GPIE        ;INTERRUPT FR EXTERNEN PIN ZULASSEN MIT CHANGE VON GP2 AUF GP0-EINGANG!!! ;ANDERS BEI GP2
                        BSF     IOC, IOC0           ;ANDERS ZUSTZLICH ZU GP2 ODER BEFEHL SO : BSF     IOC, IOC0
                        BANK0

                        BSF     INTCON, GIE         ;ALLGEMEINES INTERRUPT ENABLE 
                        BSF     INTCON, PEIE        ;INTERUPT ZULASSEN PEREPHERIE / WEIS NICHT OB ES DRIN SEIN MUSS / WAHRSCHEINLICH JA
                        ;BSF     INTCON, INTE        ;INTERRUPT EXTERNAL VON GP2 ZULASSEN !!!!DIES ENTFLLT!!!!

                        BCF     INTCON, GPIF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN
                        BCF     INTCON, INTF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

ANF                     BTFSS   HELP, BIT0      ;ABFRAGEN OB NULLDURCHGANG ERFOLGT IST (ALSO INTERRUPT AUFGETRETEN IST)
                        GOTO    ANF

                        BCF     HELP, BIT0

;VERZOEGERUNG VON MAX.10MSEC
;ZEITSCHLEIFE UNTEN
;10MSEC : 1024 (MAX. AD-WERT) = 9,765SEC

;HIER GENOMMEN 5SEC !!!!!!!!!!!!!!
;JETZT GEHT ES VON NULL BIS 235VOLT EINZUSTELLEN !!!!!!!!!!!!

ANF_1           BSF     INTCON, GIE     ;INTERRUPT ANSCHALTEN

                        MOVLW   D'5'    ;HIER DIE 5SEC
                        CALL    ZS1MUE

                        BTFSC   HELP, BIT0
                        GOTO    ANF

I_AUS           BCF     INTCON, GIE     ;INTERRUPT ABSCHALTEN SO WIE ES IM BUCH STEHT
                BTFSC   INTCON, GIE
                GOTO    I_AUS

                BTFSC   HELP, BIT0
                GOTO    ANF

;ZS1MUE NACH MAXIMAL 10MSEC BEENDEN...
                        DECFSZ  ZEIT_L, F       ;DURCHLUFE ABWRTS ZHLEN AUS INTERRUPT-AD-WANDLUNG AM POTI BERECHNET !
                        GOTO    ANF_1
                        DECFSZ  ZEIT_H, F
                        GOTO    ANF_1

                BSF     INTCON, GIE     ;INTERRUPT ANSCHALTEN

;IMPULS WEGBLENDEN MIT TASTER ODER SCHALTER
                        BTFSS   GPIO, GP3
                        GOTO    ANF

;40SEC OPTOKOPPLER IMPULS AUSGEBEN
                        BSF     GPIO, GP2      
                        MOVLW   D'40'
                        CALL    ZS1MUE
                        BCF     GPIO, GP2

                        GOTO    ANF


;*****************************************************************************
;*                              INTERRUPT                                    *
;*                              14.06.15                                     *
;*****************************************************************************
INTERRUPT       PUSH

                BCF     GPIO, GP2   ;OPTOKOPPLER LED AUS

;AD-MESSUNG AM HELLIGKEITSREGLER AN AN0
                MOVLW   B'10000100' ;ADMF=1 RECHTSBNDIG, VDD ALS REF, CHANNEL AN1, NO GO BIT1, NO ADON BIT0
                MOVWF   ADCON0

                BCF     PIR1, ADIF

;ANALOG/DIGITAL-WANDLUNG STARTEN
                BSF     ADCON0, ADON        
                MOVLW   D'200'
                CALL    ZS1MUE              ;ZEITSCHLEIFE 1SEC * 300 = 300SEC
                MOVLW   D'100'
                CALL    ZS1MUE
  
                BSF     ADCON0, GO_DONE     ;GEHT LOS

I_1             BTFSS  PIR1, ADIF
                GOTO   I_1

;ANALOG/DIGITAL-WANDLUNG STOPPEN
                BCF     ADCON0, ADON        
                BCF     ADCON0, GO_DONE    


;AD-ERGEBNIS ABSPEICHERN IN RAM-ZELLEN
                MOVF    ADRESH, W
                MOVWF   ZEIT_H
                BANK1
                MOVF    ADRESL, W
                BANK0
                MOVWF   ZEIT_L

                
                
;NEU FR INVERS / ALSO GEDREHT / POTI ANDERS HERUM ...                
;                COMF    ZEIT_H, W
;                ANDLW   0X03
;                MOVWF   ZEIT_H
                
;                COMF    ZEIT_L, F
                
                
                
                        INCF    ZEIT_H, F     ;MUSS SO SEIN !!!!!!!!!!

                        MOVF    ZEIT_L, W     ;AD_L    --> W
                        SUBLW   0X00          ;0X00-W  --> W
                        BTFSC   STATUS, Z
                        INCF    ZEIT_L, F     ;BEI 0X00 UM 1 ERHHEN SONST ERGIBT SICH 256

                BSF     HELP, BIT0            ;ES WAR EIN INTERRUPT MIT NULLDURCHGANGSERKENNUNG

                        BCF     INTCON, GPIF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN
                        BCF     INTCON, INTF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN

                POP
                RETFIE

;*****************************************************************************
;*                              1SEC ZEITSCHLEIFE                           *
;*                              03.01.14                                     *
;*****************************************************************************
;1SEC : 0,0625SEC = 16T MUESSEN ES SEIN FR EINE SEC

ZS1MUE                  MOVWF   ZAE     ;        1T=0,0625SEC
MUE                     NOP             ;4T
                        DECFSZ  ZAE, F  ;4T
                        GOTO    MUE     ;8T
                        RETURN

;*****************************************************************************
;*                              10MSEC ZEITSCHLEIFE                          *
;*                              03.01.14                                     *
;*****************************************************************************
ZS10MSEC                MOVWF   ZAE

ZS01                    MOVLW   D'100'
                        MOVWF   TMR0                    ;DER FESTE RAM-SPEICHER (TMR0) WIRD MIT 100 GELADEN
                        BCF     INTCON, T0IF            ;OVERFLOW = 0
                
ZS02                    BTFSS   INTCON, T0IF            ;WENN DIE ZEIT VON 10MSEC ABGELAUFEN IST, WIRD T0IF HIGH (1) UND 
                        GOTO    ZS02                    ;ES ERFOLGT EIN SPRUNG ZU "DECFSC ZAE, F"..... VORHER ANDERES ABARBEITEN

                        DECFSZ  ZAE, F                  ;ES WIRD DER WERT IN "ZAE" ABWRTS GEZHLT, BIS ER (0) IST UND
                        GOTO    ZS01                    ;DANN ERFOLGT EIN SPRUNG ZU "RETURN"-ENDE DES UNTERPROGRAMMS

                        RETURN

;ZEITBERECHNUNG FUER 10MS
;(HIER MUSS MAN IN DEM DATENBLATT (DATASHEET) BEI WWW.MICROCHIP.COM (EIN *.PDF-FILE) NACHSEHEN, WIE ALLES FUNKTIONIERT)

;PRESCALER 256X  *  SYSTEM 4X  * TAKTZEIT ====> 256*4*0.0625S=64S   /DIE TAKTZEIT ERGIBT SICH AUS DEM INTERNEN OSZILLATOR
;10MS : 64S= 156                                                    /T = 1 : F  (F)-OSZILLATORFREQUENZ HIER 16MHZ
;ALSO
;64S*D'156'=CA.10MSEC
;TMR0 ALSO D'256'-D'156'=D'100' ENTSPRICHT CA. 10MSEC
;100 DEZIMAL OBEN EINTRAGEN

                        END

