
;****************************************************************************************
;*                              SERVO                                                   *
;*                              01.03.16                                                *
;*--------------------------------------------------------------------------------------*
;*                                                                                      *
;* ALS PIC-IC WURDE GENOMMEN PIC12F629                                                  *
;* ALS OSZILLATOR WURDE EIN QUARZ MIT 20,00MHZ GENOMMEN.                                *
;* (T=0.050SEC ALSO DIE TAKTZEIT)                                                      *
;*  EIN BEFEHL HAT MEIST 4 TAKTE SIND 0,2SEC                                           *
;*                                                                                      *
;****************************************************************************************

        LIST    P=12F629       
        TITLE   "SERVO"

        ERRORLEVEL -302
        INCLUDE <P12F629.INC>

__CONFIG _HS_OSC & _WDT_OFF & _PWRTE_OFF & _BODEN_ON & _MCLRE_OFF & _CPD_OFF & _CP_OFF


;--------------------------------------------------------------------------
;REGISTER ZUORDNEN NACH DEM DIE FESTEN-REGISTER ZU ENDE SIND
;ES GEHT ALSO ERST AB 22 HEX LOS
;DIES IST ALSO DIE RAM-SPEICHER ZUORDNUNG


MERK                    EQU 0X22
;ZEITVARIABLE IN UNTERPROG. / VERARBEITET DIE DURCHLUFE / WIE OFT DIE ZEITSCHLEIFE ABGEARBEITET WIRD
;WERTE VON 1 DEZ. BIS 255 DEZ.

LAE                     EQU 0X23
;IMPULSLNGE VON 1,0MSEC BIS 2,0MSEC (1MSEC IST FESTE ZEIT UND MIT LAE DANN NOCH VON 0MSEC-1MSEC)
;BEI 0MSEC LAE=1DEZ. BEI 1MSEC=255DEZ. DIES SIND DIE DEZ. LAE DURCHLUFE
;IN ZSMUE MAN KANN HIER MIT NOPS DEN 2MSEC-ANSCHLAG JUSTIEREN MIT DER MAX. LNGE LAE=255DEZ.
;IN ZS1MSEC (FESTE 1MSEC-ZEITSCHLEIFE) KANN MAN MIT TIMER0 DEN 1MSEC-ANSCHLAG JUSTIEREN MIT ZEIT-VARIABLEN NDERN UND MIN. LNGE LAE=1DEZ.

HOCH                    EQU 0X24               ;BIT0 IST 1 = HOCHFAHREN /// BIT0 IST 0 = RUNTERFAHREN  /// ALSO FLATTERN
                                               ;BIT7 IST 0 = MITTELSTELLUNG BEIBEHLATEN /// BEI 1 GESCHW HAT EINFLUSS MIT HOCH-RUNTER-STELLEN

IMPULS                  EQU 0X25               ;MESSEN RX-IMPULSLNGE

GESCHW_L                EQU 0X26               ;MERKER FR GENDERTEN GESCHW-WERT

GESCHW_H                EQU 0X27               ;MERKER FR GENDERTEN GESCHW-WERT

W_STACK                 EQU 0X28               ;FUER PUSH UND POP ;FUER INTERRUPT
S_STACK                 EQU 0X29               ;FUER PUSH UND POP

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;--------------------------------------------------------------------------
;-------------------------- FESTE WERTE HIER UNTERHALB EINTRAGEN / NDERN -
;-------------------------- ALSO HIER JUSTIEREN ---------------------------
;-------------------------- MAN MUSS PROBIEREN ----------------------------

;ZU FLATTERSERVO
;ZWISCHEN DEZ. 1 UND DEZ. 255 BEFINDEN SICH DIE EINZELNEN STELLUNGEN
;MAN KANN IMMER ZWISCHEN 1 BIS 255 DIE ZAHLEN AENDERN                 
           
;MITTELERE-GRUND-NORMAL-RUHE-STELLUNG DES FLATTER-SERVOS ==>GILT BEI UNTERHALB "AB_WANN" 
;SO KANN MAN AUCH DIE FLGEL ETWAS NACH OBEN ODER UNTEN IN DER RUHESTELLUNG EINSTELLEN.
;HIER BEI 127 WAERE ES WAAGERECHTE STELLUNG (50%) DER FLUEGEL
;255 : 2 = 127 ALSO 50%                  
MITTEL_ST               EQU D'127'  
               
;-------------------------------------------------------------------------------               
;WIEDER ZWISCHEN DEZ. 1 UND DEZ. 255 BEFINDEN SICH DIE EINZELNEN STELLUNGEN
               
;WENN BEI DIESEN DAS SERVO AN DEN ANSCHLGEN ANSTOESST (MEHR STROM) SETZT MAN DIE WERTE MEHR NACH "INNEN" REIN.
;MIT Z.B. LINKER_AN EQU D'10'  UND   RECHTER_AN EQU D'245'
               
;MINIMALER LINKER FLATTER-SERVO-ANSCHLAG (KANN AUCH RECHTER SEIN)
LINKER_AN               EQU D'1'
             
;MAXIMALER RECHTER FLATTER-SERVO-ANSCHLAG (KANN AUCH LINKER SEIN)
RECHTER_AN              EQU D'255'

;-------------------------------------------------------------------------------              
;STEUERKNPPELSTELLUNG (WIEDER WERTE ZWISCHEN 1 BIS 255 DEZIMAL)
           
;AB WELCHER STEUERKNPPELSTELLUNG ES ZU FLATTERN BEGINNT
;BEI 127 WRE ES MITTELSTELLUNG MIT 50% / BEI 64 WRE ES AB EIN VIERTEL 25%
AB_WANN                 EQU D'127'  

;-------------------------------------------------------------------------------
;ZU GESCHWINDIGKEITS-EINSTELLUNG DES FLATTERNS (WIEDER WERTE ZWISCHEN 1 BIS 255 DEZIMAL)

;BEI HOHER ZAHL SCHNELL
;BEI NIEDRIGER ZAHL LANGSAM

;MINIMALE GESCHWINDIGKEIT AM ANFANG NACH STEUERKNPPELSTELLUNG "AB_WANN"
;NATRLICH MUSS DIESER WERT KLEINER ALS MAX_GESCHW SEIN !!!!
MIN_GESCHW              EQU D'6'  
              
              
;MAXIMALE GESCHWINDIGKEIT
MAX_GESCHW              EQU D'218'
              
;NATUERLICH KNNTE MAN AUCH MIT DER FERNSTEUERUNG "DEN AUSSCHLAG+GESCHWINDIGKEIT..." JUSTIEREN 
;DIES GEHT MIT DEM TRIMMEN ODER EINSTELLUNGEN IM MENUE DER FERNSTEUERUNG
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;------------------------------- ENDE -------------------------------------

;------------------------- MACROS -----------------------------------------

BANK0                   MACRO                   ;MACRO TO SELECT DATA RAM BANK 0
                        BCF     STATUS,RP0
                        ENDM
;----------------------------------------------------------------------------
BANK1                   MACRO                   ;MACRO TO SELECT DATA RAM BANK 1
                        BSF     STATUS,RP0
                        ENDM
;----------------------------------------------------------------------------
PUSH                    MACRO
                        MOVWF   W_STACK
                        MOVF    STATUS, W
                        MOVWF   S_STACK
                        ENDM
;----------------------------------------------------------------------------
POP                     MACRO
                        MOVF    S_STACK, W
                        MOVWF   STATUS
                        SWAPF   W_STACK, F
                        SWAPF   W_STACK, W
                        ENDM
;----------------------------------------------------------------------------


;VARIABLEN
BIT0        EQU 0
BIT1        EQU 1
BIT2        EQU 2
BIT3        EQU 3
BIT4        EQU 4
BIT5        EQU 5
BIT6        EQU 6
BIT7        EQU 7



;SPEICHERANFANG BZW. BEGINN
    ORG 0X0000
    GOTO MAIN           ; SPRUNG ZUM HAUPTPROGRAMM
    ORG 0X0004
    GOTO INTERRUPT      ; ZUM INTERRUPT

    ORG 0X0010
;*****************************************************************************
;*                            HAUPTPROGRAMM                                  *
;*                              04.05.12                                     *
;*****************************************************************************
;PORT-INITIALISIERUNG
MAIN                    BANK0
                        CLRF    GPIO     
                        MOVLW   0X07                        ;COMPARATORS ALLE AUS 
                        MOVWF   CMCON

                        BANK1
                        MOVLW   B'11111110'                 ;GP0 ALS AUSGANG (ALSO HIER DIE 0), SONST ALLES EINGNGE (ALSO IMMER DIE (1))
                        MOVWF   TRISIO

;INIT TIMER0
                        MOVLW   B'10000100'   ;BIT0-2 1=PRESCALER32, BIT3 0=TMR0, BIT4 0=ENTFAELLT, 
                                              ;BIT5 0=TAKT VOM SYSTEM, BIT6 0=KEIN RB-INTERRUPT, BIT7 1=PULL-UPS DISABLE 
                        MOVWF   OPTION_REG

;INIT INTERRUPT AN GP2
                        BCF     OPTION_REG, INTEDG  ;FALLENDE FLANKE ZULASSEN 
                        BANK0


                        BCF     GPIO, GP0                   ;AUS


;INTERRUPT GP2 INIT / ZULASSEN
;NUR FUER GP2 KEIN CHANGE !
;FR EMPFNGER-SERVO-IMPULS VON 1,9MSEC-2,1MSEC MESSEN
                        ;BSF     INTCON, PEIE        ;PEREPHERIE INTERRUPT ZULASSEN
                        BSF     INTCON, INTE        ;INTERRUPT EXTERNAL VON GP2 ZULASSEN

                        BCF     INTCON, GPIE        ;INTERRUPT FR EXTERNEN PIN NICHT ZULASSEN 
                                                    ;MIT CHANGE VON GP2 AUF GPX-EINGANG!!!

                        BCF     INTCON, GPIF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN
                        BCF     INTCON, INTF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN
;----------------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------------
;INTERRUPT TIMER1 EINSCHALTEN FUER GESCHWINDIGKEIT WIE SCHNELL HOCH RUNTER
                BSF     INTCON, PEIE        ;PEREPHERIE INTERRUPT ZULASSEN

                BCF     PIR1, TMR1IF    ;OVERFLOW 0 MACHEN
        
                BANK1
                BSF     PIE1, TMR1IE    ;OVERFLOW INTERRUPT BEI TIMER1 ZULASSEN/ENABLE
                BANK0
            
                MOVLW   0X94            
                MOVWF   TMR1L           
                MOVLW   0X94
                MOVWF   TMR1H

                MOVLW   0X01            ;PRESCALE1:1 / SYSTEMCLOCK T/4 ==>1/4
                MOVWF   T1CON           ;START TIMER1

;----
;FUER 1,5SEC EINMAL HOCH FR TIMER1
;1,5SEC : 255 = 5,8MSEC ZEIT FR KLEINSTEN INTERRUPT /// GENOMMEN CA. 5,5MSEC

;ZEITBERECHNUNG FR 5,5MSEC TIMER1
;PRESCALER 1X  *  SYSTEM 4X  * TAKTZEIT ====> 1*4*0.05SEC=0,2SEC 
;5,5MS : 0,2SEC= 27500
;ALSO
;0XFFFF (D'65535') - D'27500' (0X6B6C) = 0X9493 GENOMMEN 0X9494
;TMR1L = 0X94  UND  TMR1H = 0X94  DIES OBEN EINTRAGEN

;------------------------- INITIALISIERUNG PORTS ZU ENDE --------------------------------------------
;----------------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------------

            MOVLW   D'10'
            CALL    ZS1MSEC     ;10MSEC ZEITSCHLEIFE DAMIT SICH KONDENSATOREN AUFLADEN NACH DEM EINSCHALTEN

            BSF     INTCON, GIE         ;INTERRUPT EINSCHALTEN

ANF         MOVLW   MITTEL_ST           ;FR MITTELSTELLUNG
            MOVWF   LAE

            BCF     HOCH, BIT7  ;FR MITTELSTELLUNG BEIBEHALTEN
            BCF     HOCH, BIT0  ;FR RUNTER VON 255 BIS 1

;----------------------------------------------------------------------------------------------------
;IMPULS 1MSEC BIS 2MSEC

;VON 1,0MSEC BIS 2,0MSEC +5VOLT IMPULSE DANN 20MSEC PAUSE
;FESTE ZEIT 1,0MSEC MIT TIMER0
;DAZU NOCH ZEIT
;1,0MSEC : 250 = 4SEC SIEHE ZSMUE DIE NOP-ANZAHL UND DURCHLUFE VON LAE

ANF1        BCF     INTCON, GIE     ;INTERRUPT ABSCHALTEN SO WIE ES IM BUCH STEHT
            BTFSC   INTCON, GIE
            GOTO    ANF1

            BSF     GPIO, GP0       ;EIN +5VOLT

;FESTE IMPULS-ZEIT 1,0MSEC
            MOVLW   D'1'            ;FESTE ZEIT 1,0MSEC
            CALL    ZS1MSEC

            MOVF    LAE, W
            CALL    ZSMUE           ;SEC-ZEITSCHLEIFE IN SCHRITTEN MAX. 250MAL BIS ALSO AUCH 1,0MSEC

            BCF     GPIO, GP0       ;AUS NULL VOLT

;ANHNGENDEN GP2-INTERRUPT LSCHEN, ALSO WELCHER WHREND DES 0,9MSEC - 2,1MSEC IMPULS GEKOMMEN WAR
            BCF     INTCON, GPIF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN
            BCF     INTCON, INTF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN
            BSF     INTCON, GIE         ;INTERRUPT EINSCHALTEN

;----
;20MSEC PAUSE
            MOVLW   D'20'
            CALL    ZS1MSEC
;----
            GOTO    ANF1


;*****************************************************************************
;*                              INTERRUPT-PROGRAMM                           *
;*                              19.09.05                                     *
;*****************************************************************************
INTERRUPT       PUSH

                BTFSC   INTCON, INTF    ;WENN ES EIN SERVO-IMPULS AN GP2 IST ZU RX_MESS
                GOTO    RX_MESS

;HIER GESCHWINDIGKEIT
;INNERHALB DER JEWEILIGEN INTERRUPT-ZEIT MIT TIMER1
;HIER MITTELSTELLUNG
                BCF     T1CON, TMR1ON   ;TIMER1 ANHALTEN
                BTFSC   HOCH, BIT7      ;BEI LOW MITTELSTELLUNG BEI BEHALTEN
                GOTO    IV1             ;ZU DREHEN

                MOVLW   0X94            ;NUR TIMER1 WIEDER STARTEN MIT 5,5MSEC-INTERRUPT          
                MOVWF   TMR1L          
                MOVLW   0X94
                MOVWF   TMR1H
                BCF     PIR1, TMR1IF    ;OVERFLOW 0 MACHEN
                BSF     T1CON, TMR1ON   ;TIMER1 STARTEN
                GOTO    RXEND

;HIER INTERRUPT-ZEIT NACH EMPFNGER-IMPULS-LNGE JEDES MAL STELLEN
;UND LAE +1 ODER -1
;LAE VON 1(LINKER-ANSCHLAG) INCFSZ BIS 255(RECHTER-ANSCHLAG) DECF BIS 1 ERREICHT
IV1             BTFSS   HOCH, BIT0      ;RICHTUNG OB HOCH(BEI HIGH) ODER RUNTER(BEI LOW)
                GOTO    IV2    

                INCF    LAE, F          ;HIER HOCH

                MOVLW   RECHTER_AN      ;IN W DEZ. 1 LADEN
                SUBWF   LAE, W          ;LAE - W(D'1') =>ERGEBNIS IN W / LAE BLEIBT ERHALTEN
                BTFSS   STATUS, Z       ;ZERO-ABFRAGE BEI HIGH(1) IST ES GLEICH / BEI LOW (0) UNGLEICH
                GOTO    TIM

;BER 255DEZ.
                BCF     HOCH, BIT0      ;FR JETZT DANN HOCH BIS 255
                MOVLW   RECHTER_AN
                MOVWF   LAE
                GOTO    TIM


IV2             DECF    LAE, F          ;HIER RUNTER

                MOVLW   LINKER_AN       ;IN W DEZ. 1 LADEN
                SUBWF   LAE, W          ;LAE - W(D'1') =>ERGEBNIS IN W / LAE BLEIBT ERHALTEN
                BTFSS   STATUS, Z       ;ZERO-ABFRAGE BEI HIGH(1) IST ES GLEICH / BEI LOW (0) UNGLEICH
                GOTO    TIM

;BEI LAE GLEICH 1
                BSF     HOCH, BIT0      ;FR JETZT DANN RUNTER BIS 1
                MOVLW   LINKER_AN
                MOVWF   LAE

TIM             MOVF    GESCHW_L, W     ;NUR TIMER1 WIEDER STARTEN MIT VARIABLEM INTERRUPT NACH GESCHWINDIGKEIT
                MOVWF   TMR1L          
                MOVF    GESCHW_H, W
                MOVWF   TMR1H
                BCF     PIR1, TMR1IF    ;OVERFLOW 0 MACHEN
                BSF     T1CON, TMR1ON   ;TIMER1 STARTEN
                GOTO    RXEND

;------------------------------------------------------------------------------------------------------
;EMPFNGER-IMPULS-LNGE MESSEN
;FESTE IMPULS-ZEIT 0,9MSEC
RX_MESS     MOVLW   D'111'
            MOVWF   TMR0                    ;DER FESTE RAM-SPEICHER (TMR0) WIRD MIT 100 GELADEN
            BCF     INTCON, T0IF            ;OVERFLOW = 0
                
RX0         BTFSS   INTCON, T0IF            ;WENN DIE ZEIT VON 1MSEC ABGELAUFEN IST, WIRD T0IF HIGH (1) UND 
            GOTO    RX0                     ;ES ERFOLGT EIN SPRUNG ZU "DECFSC MERK, F"..... VORHER ANDERES ABARBEITEN


;IMPULSZEIT MESSEN
            MOVLW   D'1'
            MOVWF   IMPULS

RX1         NOP 
            NOP
            NOP
            NOP
            NOP

            NOP
            NOP
            NOP
            NOP
            NOP

            NOP
            NOP
            NOP
            NOP
            NOP

            NOP
            NOP
            NOP
            NOP
            NOP     ;20-ZIGSTER NOP /// SIEHE UNTERPROGRAMM ZSMUE JUSTAGE...

            NOP

            ;NOP
            ;NOP   ;JUSTIERT
            ;NOP

            INCFSZ  IMPULS, F
            GOTO    RX2

            MOVLW   0XFF        ;BERLAUF BEI GRSSER 2,1MSEC
            MOVWF   IMPULS
RX3         BTFSS   GPIO, GP2
            GOTO    RX3
            GOTO    RXSTELL

RX2         BTFSS   GPIO, GP2   ;STEIGENDE FLANKE == ZEITMESSUNG BEENDEN
            GOTO    RX1

;--------------------------------------------------------------------------------------
;--------------------------------------------------------------------------------------

RXSTELL     
;FUER GRER KLEINER / FUER MITTELSTELLUNG
            MOVLW   AB_WANN         ;IN W DEZ. 127 LADEN MITTELSTELLUNG
            SUBWF   IMPULS, W       ;IMPULS - W(D'127') =>ERGEBNIS IN W / IMPULS BLEIBT ERHALTEN
            BTFSC   STATUS, C       ;CARRY-ABFRAGE 
            GOTO    RXGESCHW        ;GLEICH_GROESSER ;IMPULS IST GLEICH + GROESSER BEI 1

;MITTELSTELLUNG
            BCF     HOCH, BIT7      ;BEI LOW IST ES MITTELSTELLUNG + BLEIBT SO     BIS SICH IMPULSLNGE ZU GRSSER NDERT
            MOVLW   MITTEL_ST
            MOVWF   LAE
            GOTO    RXEND


RXGESCHW    BSF     HOCH, BIT7      ;BEI HIGH FLATTERT ES JE NACH GESCHINDIGKEIT TIMER1 HIER NDERN
                                    ;BEI VARIABLE "IMPULS" 128 LANGSAM  / BEI 255 SCHNELL

;GESCHWINDIGKEIT EINSTELLEN ZUM NDERN...
;BERGEBEN DANN AN VARIABLE M_GESCHW
;TIMER1 BERECHNUNG
;FUER 1,5SEC EINMAL HOCH RUNTER
;STELLBEREICH: 255-128=127
;1,5SEC : 255 = 5,88MSEC ZEIT FR GRSSTE ZEIT VON 1,5SEC 

;ZEITBERECHNUNG FR 11,8MSEC TIMER1
;PRESCALER 1X  *  SYSTEM 4X  * TAKTZEIT ====> 1*4*0.05SEC=0,2SEC 
;5,88MS : 0,2SEC= 29411
;ALSO GRSSTER ZEITWERT
;0XFFFF - D'29411' (0X72E3) = 0X8D1C 
;TMR1L = 0X1C  UND  TMR1H = 0X8D
;ALSO
;STELLBEREICH 128-255=127  *4=508 (0X01FC) DANN 2*LINKS SCHIEBEN
;0X8D1C+0X01FC=0X8F18
;0XFFFF-0X8F18=0X70E7 (DEZ.28903)*0,2SEC=5,78MSEC ///RICHTUNGSSINN STIMMT 

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;MIN GESCHWINDIGKEIT 0X1100 BEI GRSSEREN WERT WIRD ES SCHNELLER
;ANFANGS-GESCHWINDIGKEIT !!!! BEI MITTELSTELLUNG BEGINN -SIEHE OBERHALB-
                MOVLW   MIN_GESCHW
                MOVWF   GESCHW_H
                MOVLW   0X00
                MOVWF   GESCHW_L

                MOVF    IMPULS, W
                ADDWF   GESCHW_H, F

;MAX GESCHWINDIGKEIT
;FUER GRER KLEINER / FUER BERSCHREITUNG MAX.GESCHWINDIGKEIT BLOCKIERT BLEIBT SO !!!!
            MOVLW   MAX_GESCHW        ;IN W HEX LADEN 
            SUBWF   GESCHW_H, W       ;GESCHW_H - W =>ERGEBNIS IN W / GESCHW_H BLEIBT ERHALTEN
            BTFSS   STATUS, C         ;CARRY-ABFRAGE 
            GOTO    RXEND             ;KLEINER ;GESCHW_H IST KLEINER BEI LOW

            MOVLW   MAX_GESCHW        ;GESCHWINDIGKEIT BLEIBT SO BEI GRSSER 0XDA / BLEIBT BEI 0XDA
            MOVWF   GESCHW_H
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


RXEND           BCF     INTCON, GPIF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN
                BCF     INTCON, INTF        ;INTERRUPT-FLAG WIRD ERST BEI INTERRUPT GESETZT / JETZT LSCHEN

                POP
                RETFIE


;*****************************************************************************
;*                              X * 4SEC ZEITSCHLEIFE                       *
;*                              31.10.03                                     *
;*****************************************************************************
ZSMUE       MOVWF   MERK

A1          NOP 
            NOP
            NOP
            NOP
            NOP

            NOP
            NOP
            NOP
            NOP
            NOP

            NOP
            NOP
            NOP
            NOP
            NOP

            NOP
            NOP
            NOP
            NOP
            NOP     ;20-ZIGSTER NOP

            NOP
 
            ;NOP
            ;NOP   ;JUSTIERT
            ;NOP

            DECFSZ  MERK, F
            GOTO    A1

            RETURN          ;DECFSZ 4T / JE NOP 4T  /// 1T=0,05SEC

                            ;1,1MSEC : 250 ALS MAX.-WERT FR MERK = 4,4SEC
                            ;4,4SEC : 0,05SEC = 88T
                            ;88T - 4T-FR DECFSZ = 84T : 4T-FR EINEM NOP = 21MAL NOPS
                            ;ES WURDE AUCH HIER JUSTIERT

;*****************************************************************************
;*                              UNTERPROGRAMM 1MSEC ZEITSCHLEIFE TIMER0      *
;*                              03.01.14                                     *
;*****************************************************************************
ZS1MSEC                 MOVWF   MERK

ZS11                    MOVLW   D'111'
                        MOVWF   TMR0                    ;DER FESTE RAM-SPEICHER (TMR0) WIRD MIT 100 GELADEN
                        BCF     INTCON, T0IF            ;OVERFLOW = 0
                
ZS12                    BTFSS   INTCON, T0IF            ;WENN DIE ZEIT VON 1MSEC ABGELAUFEN IST, WIRD T0IF HIGH (1) UND 
                        GOTO    ZS12                    ;ES ERFOLGT EIN SPRUNG ZU "DECFSC MERK, F"..... VORHER ANDERES ABARBEITEN

                        DECFSZ  MERK, F                 ;ES WIRD DER WERT IN "MERK" ABWRTS GEZHLT, BIS ER (0) IST UND
                        GOTO    ZS11                    ;DANN ERFOLGT EIN SPRUNG ZU "RETURN"-ENDE DES UNTERPROGRAMMS

                        RETURN

;ZEITBERECHNUNG FUER 1MS
;PRESCALER 32X  *  SYSTEM 4X  * TAKTZEIT ====> 32*4*0.05SEC=6,4SEC 
;1MS : 6,4SEC= 156,25                                     
;ALSO NACHRECHNUNG 
;6,4SEC*D'156'=0,9984MSEC
;TMR0 ALSO D'256'-D'156'=D'100' ENTSPRICHT CA. 1MSEC
;100 DEZIMAL OBEN EINTRAGEN

;JUSTAGE
;6,4SEC*D'145'=0,928MSEC
;TMR0 ALSO D'256'-D'145'=D'111' ENTSPRICHT CA. 1MSEC
;111 DEZIMAL OBEN EINTRAGEN

;6,4SEC*D'120'=0,768MSEC
;TMR0 ALSO D'256'-D'120'=D'136' ENTSPRICHT CA. 1MSEC
;136 DEZIMAL OBEN EINTRAGEN

;6,4SEC*D'110'=0,704MSEC
;TMR0 ALSO D'256'-D'110'=D'146' ENTSPRICHT CA. 1MSEC
;146 DEZIMAL OBEN EINTRAGEN
;IST OK

;NOCHMALS GENDERT AUF 111 DEZ...



            END
