
    
    
       
;****************************************************************************************
;*                                                                                      * 
;*                            TONGENERATOR FUER KEYER                                   *
;*                            =======================                                   *
;*                                                                                      *
;*                                   27.03.24                                           *
;*                                                                                      *    
;****************************************************************************************


    LIST    P=PIC12F683
 
    ;TITLE   "GENERATOR"

    ERRORLEVEL -302
    INCLUDE <P12F683.INC>

;--------------------------------------------------------------------------

;ALS OSZILLATOR INTERN 4MHZ  (T=0.250SEC T:=TAKTZEIT)

;---------------------------------------------------------------------------------

__CONFIG _INTRC_OSC_NOCLKOUT &_INTOSCIO & _IESO_OFF & _FCMEN_OFF &_WDT_OFF & _PWRTE_OFF & _BOD_OFF & _MCLRE_OFF & _CPD_OFF & _CP_OFF
          
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
;VARIABLEN
BIT0        EQU 0
BIT1        EQU 1
BIT2        EQU 2
BIT3        EQU 3
BIT4        EQU 4
BIT5        EQU 5
BIT6        EQU 6
BIT7        EQU 7
        
GP0         EQU 0
GP1         EQU 1 
GP2         EQU 2 
GP3         EQU 3 
GP4         EQU 4
GP5         EQU 5 

;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
OUT        EQU 1   ;GP1 AUSGANG 
IN         EQU 4   ;GP4 EINGANG  
;---------------------------------------------------------------------------------
;--------------------------------------------------------------------------------- 
         
;------------------------- MACROS -----------------------------------------

BANK0                   MACRO                   ;MACRO TO SELECT DATA RAM BANK 0
                        BCF     STATUS,RP0
                        ENDM
;----------------------------------------------------------------------------
BANK1                   MACRO                   ;MACRO TO SELECT DATA RAM BANK 1
                        BSF     STATUS,RP0
                        ENDM
;----------------------------------------------------------------------------

;REGISTER ZUORDNEN NACH DEM DIE FESTEN-REGISTER ZU ENDE SIND
;ES GEHT ALSO ERST AB 21 HEX LOS
;ALSO DIE RAM-SPEICHER ZUORDNUNG
 
;FUER ZEITSCHLEIFEN         
HELP1       EQU 0X21
HELPX       EQU 0X22
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------   
;---------------------------------------------------------------------------------
;SPEICHERANFANG BZW. BEGINN

    ORG 0X0000
    GOTO    MAIN        ;SPRUNG ZUM HAUPTPROGRAMM
    ORG 0X0004
    RETFIE              ;GOTO INTERRUPT /// JETZT KEIN INTERUPT


    ORG 0X0010                     
;*****************************************************************************
;*                            HAUPTPROGRAMM                                  *
;*****************************************************************************
;PORT-INITIALISIERUNG
MAIN                    BANK0
                        CLRF    GPIO     
                        MOVLW   0X07                        ;COMPARATORS ALLE AUS 
                        MOVWF   CMCON0

                        BANK1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;ANALOG/DIGITAL
                        CLRF    ANSEL                       ;ANALOG/DIGITAL ALLES I/O
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

                        MOVLW   B'11111101'                 ;GP1 ALS AUSGANG (ALSO HIER DIE 0), SONST ALLES EINGNGE (ALSO IMMER DIE (1))
                        MOVWF   TRISIO

;OSCILLATOR AUF 4MHZ INTERN EINSTELLEN
                        MOVLW   B'01100101'
                        MOVWF   OSCCON

;INIT TIMER 0 FUER 10MSEC FUER ZEITSCHLEIFE 
;(HIER MUSS MAN IN DEM DATENBLATT (DATASHEET) BEI WWW.MICROCHIP.COM (EIN *.PDF-FILE) NACHSEHEN, WIE ALLES FUNKTIONIERT)
                        MOVLW   B'10000100'                 ;BIT0-2 111=PRESCALER32, BIT3 0=TMR0, BIT4 0=ENTFAELLT, BIT5 0=TAKT VOM SYSTEM, BIT6 0=KEIN RB-INTERRUPT, BIT7 1=PULL-UPS DISABLE 
                        MOVWF   OPTION_REG      
                        BANK0
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
          
                        CLRF   GPIO
;---------------INITIALISIERUNG--ZU--ENDE-----------------------
;---------------------------------------------------------------------------------                        

                        MOVLW   D'50'       ;50MSEC ZEITSCHLEIFE   
                        CALL    ZS1MSEC     ;WEGEN KONDENSATOREN AUFLADEN... LCD-MODUL


ANFANG                  BTFSS   GPIO, IN   ;TON KOMMT NUR BEI HIGH +5V AM EINGANG RAUS // 
                        GOTO    WEITER01    ;SONST IST DER AUSGANG IMMER LOW (DURCH DEN LAUTSPRECHER FLIESST KEIN STROM) 
                        
                        BSF     GPIO, OUT
                        MOVLW   D'62'
                        CALL    ZS10MUESEC

WEITER01                BCF     GPIO, OUT
                        MOVLW   D'62'
                        CALL    ZS10MUESEC
                        GOTO    ANFANG
                        
;FREQUENZ-BERECHNUNG FUER 800HZ
;F=1:T  T=1:FREQUENZ
;T=1:800HZ=1,25MSEC    //     DA 2 HALBWELLEN :2=625SEC   //     GENOMMEN 620SEC
;MIT GEMESSEN KAMEN 795HZ RAUS === GEHT SO


;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
;---------------------- UNTERPROGRAMME ZEITSCHLEIFEN ---------------------------
            
;*****************************************************************************
;*                            ZEITSCHLEIFE  CA. X-MAL 10SEC                 *
;*****************************************************************************
ZS10MUESEC  MOVWF   HELPX
ZZS01       NOP                 ;EIN NOP = 0.25SEC *T=4 = 1SEC  
            NOP
            NOP
            NOP
            NOP
              
            NOP
            NOP
            ;NOP
            ;NOP
            ;NOP
            
            DECFSZ  HELPX, F    ;T=4
            GOTO    ZZS01       ;T=8    GESAMT=12 3STCK. NOPS WEGLASSEN
            RETURN    

;MIT 8XNOP(T=4) GESAMT(T=32) 32*0,03125SEC=1SEC
    
;*****************************************************************************
;*                            ZEITSCHLEIFE TIMER0 X-MAL 1MSEC                *
;*****************************************************************************                   
ZS1MSEC                 MOVWF   HELP1

Z01                     MOVLW   D'225'
                        MOVWF   TMR0                    
                        BCF     INTCON, T0IF          ;OVERFLOW = 0
                 
Z02                     BTFSS   INTCON, T0IF            
                        GOTO    Z02                    
                      
                        DECFSZ  HELP1, F
                        GOTO    Z01
                        
                        RETURN

;ZEITBERECHNUNG FUER 1MSEC
;PRESCALER 32X  +  SYSTEM 4X  ====> 32*4*0.25SEC=32SEC
;1MSEC:32SEC=31,25 GENOMMEN 31    
;TMR0 ALSO D'256'-D'31'=D'225' ENTSPRICHT CA. 1MSEC
;225 DEZIMAL OBEN EINTRAGEN
                            

                        END