
 
    
;****************************************************************************************
;*                                                                                      * 
;*                            TONGENERATOR FUER KEYER                                   *
;*                            =======================                                   *
;*                                                                                      *
;*                                   27.03.24                                           *
;*                                                                                      *    
;****************************************************************************************


    LIST    P=PIC12F1840
 
    ;TITLE   "GENERATOR"

    ERRORLEVEL -302
    INCLUDE <P12F1840.INC>

;--------------------------------------------------------------------------

;ALS OSZILLATOR INTERN 4MHZ  (T=0.250SEC T:=TAKTZEIT)

;---------------------------------------------------------------------------------
 
 __CONFIG _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_OFF & _MCLRE_OFF & _CP_OFF & _BOREN_ON & _IESO_OFF & 0X3FFF
 __CONFIG _CONFIG2, _WRT_OFF & _PLLEN_OFF & _BORV_HI & _LVP_OFF & 0X3FFF
           
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
;VARIABLEN
BIT0        EQU 0
BIT1        EQU 1
BIT2        EQU 2
BIT3        EQU 3
BIT4        EQU 4
BIT5        EQU 5
BIT6        EQU 6
BIT7        EQU 7
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
OUT        EQU 1   ;RA1 AUSGANG 
IN         EQU 4   ;RA4 EINGANG  
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------      
;REGISTER ZUORDNEN NACH DEM DIE FESTEN-REGISTER ZU ENDE SIND
;ES GEHT ALSO ERST AB 21 HEX LOS
;ALSO DIE RAM-SPEICHER ZUORDNUNG
 
;FUER ZEITSCHLEIFEN         
HELP1       EQU 0X21
HELPX       EQU 0X22
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------   
;---------------------------------------------------------------------------------
;SPEICHERANFANG BZW. BEGINN

    ORG 0X0000
    GOTO    MAIN        ;SPRUNG ZUM HAUPTPROGRAMM
    ORG 0X0004
    RETFIE              ;GOTO INTERRUPT /// JETZT KEIN INTERUPT


    ORG 0X0010                     
;*****************************************************************************
;*                            HAUPTPROGRAMM                                  *
;*****************************************************************************
;PORT-INITIALISIERUNG USW...
MAIN                    MOVLB   D'0'        ;BANK0
                        CLRF    PORTA
                        
                        MOVLB   D'2'        ;BANK2
                        CLRF    LATA                    ;DATA-LATCH
                                                
                        MOVLB   D'1'        ;BANK1
                        MOVLW   B'11111101'             ;ALLES ALS EINGANG (ALSO HIER DIE 1) NUR RA1 AUSGANG
                        MOVWF   TRISA
                        
;FR DEN INTERNEN OSZILLATOR 4MHZ 
                        MOVLW   B'01101000'             ;JETZT 4MHZ INTERN OHNE PLL*4                
                        MOVWF   OSCCON
                        
;INIT TIMER 0 FUER ZEITSCHLEIFE
                        MOVLW   B'10000100'             ;BIT0-2 000=PRESCALER32, BIT3 0=TMR0, BIT4 0=ENTFAELLT, BIT5 0=TAKT VOM SYSTEM, BIT6 0=KEIN RB-INTERRUPT, BIT7 1=PULL-UPS DISABLE 
                        MOVWF   OPTION_REG 

                        MOVLB   D'3'        ;BANK3
                        CLRF    ANSELA                  ;ALLES I/O PINS AM PORTS KEIN ANALOG
                        
                        MOVLB   D'4'        ;BANK4   
                        CLRF    WPUA                    ;ALLES KEIN PULL-UP
                        
;---------------------------------------------------------------------------------                        

                        MOVLB   D'0'         ;BANK0
                        BCF     PORTA, OUT   

                        MOVLW   D'50'       ;50MSEC ZEITSCHLEIFE   
                        CALL    ZS1MSEC     ;WEGEN KONDENSATOREN AUFLADEN... LCD-MODUL


ANFANG                  BTFSS   PORTA, IN   ;TON KOMMT NUR BEI HIGH +5V AM EINGANG RAUS // 
                        GOTO    WEITER01    ;SONST IST DER AUSGANG IMMER LOW (DURCH DEN LAUTSPRECHER FLIESST KEIN STROM) 
                        
                        BSF     PORTA, OUT
                        MOVLW   D'62'
                        CALL    ZS10MUESEC

WEITER01                BCF     PORTA, OUT
                        MOVLW   D'62'
                        CALL    ZS10MUESEC
                        GOTO    ANFANG
                        
;FREQUENZ-BERECHNUNG FUER 800HZ
;F=1:T  T=1:FREQUENZ
;T=1:800HZ=1,25MSEC    //     DA 2 HALBWELLEN :2=625SEC   //     GENOMMEN 620SEC
;MIT GEMESSEN KAMEN 795HZ RAUS === GEHT SO


;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
;---------------------- UNTERPROGRAMME ZEITSCHLEIFEN ---------------------------
            
;*****************************************************************************
;*                            ZEITSCHLEIFE  CA. X-MAL 10SEC                 *
;*****************************************************************************
ZS10MUESEC  MOVWF   HELPX
ZZS01       NOP                 ;EIN NOP = 0.25SEC *T=4 = 1SEC  
            NOP
            NOP
            NOP
            NOP
              
            NOP
            NOP
            ;NOP
            ;NOP
            ;NOP
            
            DECFSZ  HELPX, F    ;T=4
            GOTO    ZZS01       ;T=8    GESAMT=12 3STCK. NOPS WEGLASSEN
            RETURN    

;MIT 8XNOP(T=4) GESAMT(T=32) 32*0,03125SEC=1SEC
    
;*****************************************************************************
;*                            ZEITSCHLEIFE TIMER0 X-MAL 1MSEC                *
;*****************************************************************************                   
ZS1MSEC                 MOVWF   HELP1

Z01                     MOVLW   D'225'
                        MOVWF   TMR0                    
                        BCF     INTCON, TMR0IF          ;OVERFLOW = 0
                 
Z02                     BTFSS   INTCON, TMR0IF            
                        GOTO    Z02                    
                      
                        DECFSZ  HELP1, F
                        GOTO    Z01
                        
                        RETURN

;ZEITBERECHNUNG FUER 1MSEC
;PRESCALER 32X  +  SYSTEM 4X  ====> 32*4*0.25SEC=32SEC
;1MSEC:32SEC=31,25 GENOMMEN 31    
;TMR0 ALSO D'256'-D'31'=D'225' ENTSPRICHT CA. 1MSEC
;225 DEZIMAL OBEN EINTRAGEN
                            
    
                        
                        END





