;****************************************************************************************
;*                              KEYER III                                               *
;*                                                                                      *
;*ALS PIC-IC WURDE GENOMMEN PIC16F876 OHNE A AM SCHLUSS                                 *
;*ALS OSZILLATOR WURDE EIN QUARZ MIT 8,00MHZ GENOMMEN.(T=0,125SEC ALSO DIE TAKTZEIT)   *
;*                                   EIN BEFEHL HAT MEIST 4 TAKTE SIND 0,5SEC          *
;*                                                                                      *
;*--------------------------------------------------------------------------------------*
;*                             BEGINN: 28.12.25                                         *
;*                             ENDE  : 01.01.26                                         *
;****************************************************************************************

    LIST    P=16F876  
    TITLE   "KEYERIII"

    INCLUDE <P16F876.INC>
    ERRORLEVEL -302
    ERRORLEVEL -306
    
__CONFIG  _HS_OSC & _WDT_OFF & _PWRTE_OFF & _CP_OFF & _BODEN_ON & _LVP_OFF & _CPD_OFF 
       
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;PORTZUORDNUNG==>

;EING.  PORTA   RA0 POTI TEMPO XX-ZPM
;EING.  PORTA   RA1 FREI
;EING.  PORTA   RA2 FREI
;EING.  PORTA   RA3 FREI
;EING.  PORTA   RA4 FREI
;EING.  PORTA   RA5 FREI
;
;EING.  PORTB   RB7 PADDEL PUNKT
;EING.  PORTB   RB6 PADDEL STRICH
;EING.  PORTB   RB5 TASTER TEXT5
;EING.  PORTB   RB4 TASTER TEXT4
;EING.  PORTB   RB3 TASTER TEXT3
;EING.  PORTB   RB2 TASTER TEXT2      
;EING.  PORTB   RB1 TASTER TEXT1
;EING.  PORTB   RB0 TASTER TEXT0
;  
;AUSG.  PORTC   RC0 CW AUSGANG 
;AUSG.  PORTC   RC1 LED GN FUER PROGRAMMIEREN
;AUSG.  PORTC   RC2 LED RT FUER CW-ENDE
;AUSG.  PORTC   RC3 LED GN FUER CW-NORMAL
;EING.  PORTC   RC4 SCHALTER PROGRAMMIEREN FESTTEXT
;EING.  PORTC   RC5 FREI
;EING.  PORTC   RC6 FREI
;AUSG.  PORTC   RC7 MITHOERTON AUSGANG
;------------------------- MACROS ------------------------------------------------
BANK0           MACRO           ;MACRO TO SELECT DATA RAM BANK 0
                BCF STATUS,RP0
                BCF STATUS,RP1
                ENDM

BANK1           MACRO           ;MACRO TO SELECT DATA RAM BANK 1
                BSF STATUS,RP0
                BCF STATUS,RP1
                ENDM

BANK2           MACRO           ;MACRO TO SELECT DATA RAM BANK 2
                BCF STATUS,RP0
                BSF STATUS,RP1
                ENDM

BANK3           MACRO           ;MACRO TO SELECT DATA RAM BANK 3
                BSF STATUS,RP0
                BSF STATUS,RP1
                ENDM
;---------------------------------------------------------------------------------
;------------------------- ENDE MACROS -------------------------------------------
;------------------------- VARIABLEN ---------------------------------------------
;HIER KANN MAN AENDERN:         
LED_VORHER      EQU D'25'   ;ROTE LED SOLL 25ZEICHEN VOR DEM ENDE LEUCHTEN
;---------------------------------------------------------------------------------
;---------------------------------------------------------------------------------      
BIT0            EQU 0
BIT1            EQU 1
BIT2            EQU 2
BIT3            EQU 3
BIT4            EQU 4
BIT5            EQU 5
BIT6            EQU 6
BIT7            EQU 7
;---------------------------------------------------------------------------------
;PORT-ZUORDNUNGS-VARIABLEN          
LED_GN_PROG     EQU 1 ;RC1
LED_GN_CW       EQU 3 ;RC3
LED_RT_ENDE     EQU 2 ;RC2
        
MORSE           EQU 0 ;RC0 CW-AUSG.
MITHOERTON      EQU 7 ;RC7 MITHOERTON
PROGRAMMIEREN   EQU 4 ;RC4 PROGRAMMIEREN SCHALTER // BEI LOW NICHT AKTIV --DESHALB KANN MAN EINE MASSE-BRUECKE MACHEN OHNE ZU SPEICHERN       
        
CW_PUNKT        EQU 7 ;RB7
CW_STRICH       EQU 6 ;RB6
        
FESTTEXT5       EQU 5 ;RB5
FESTTEXT4       EQU 4 ;RB4
FESTTEXT3       EQU 3 ;RB3
FESTTEXT2       EQU 2 ;RB2
FESTTEXT1       EQU 1 ;RB1
FESTTEXT0       EQU 0 ;RB0
;------------------------- ENDE VARIABLEN ----------------------------------------
;---------------------------------------------------------------------------------
;REGISTER ZUORDNEN NACH DEM DIE FESTEN-REGISTER ZU ENDE SIND / ALSO AB 0X22
;ALSO RAM-SPEICHER ZUORDNUNG
MERK                    EQU     0X22               
MERK1                   EQU     0X23
CW                      EQU     0X24            
TXT_ZAE                 EQU     0X25
ANZ                     EQU     0X26
STRPKT                  EQU     0X27
;FUER STRPKT GILT:
;BIT7 BEI 1 -STRICH MERKER BEI NORMALEM PADDEL-BETRIEB
;BIT0 BEI 1 -PUNKT MERKER BEI NORMALEM PADDEL-BETRIEB
;--
;BIT2 BEI 1 -IST SPEICHERENDE ERREICHT MIT 0XFA
;BIT4 BEI 1 -IST MERKER FR FESTTEXT-MORSEN GLEICH NACH DEM START
;BIT5 BEI 1 -IST MERKER WENN STRICH GEDRCKT IST GEHT ES ZUM BAKEN MORSEN BER
;BIT6 BEI 1 -IST ES PADDLE MORSEN / BEI 0 IST ES FESTTEXTMORSEN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AD_L                    EQU     0X28
AD_H                    EQU     0X29
ZAE                     EQU     0X2A
ZAE1                    EQU     0X2B    ;ABBRUCH BAKE DAMIT MAN PUNKT NICHT HOERT --ENTPRELLUNG

SP_BYTE                 EQU     0X2C
ZAEHLER                 EQU     0X2D
ADR_MERK                EQU     0X2E
MERK2                   EQU     0X2F
ZAEHLER1                EQU     0X30        

ABFRAGE                 EQU     0X31
;FUER ABFRAGE GILT:              
;BIT0 BEI 1 -BLINKEN BEI PROGRAMMIER-SCHALTER UNTERBRECHEN -SONDERN DAUERLEUCHTEN UND ABFRAGE TXT-TASTER

F_SPEICHER_L            EQU     0X32    ;FLASH-SPEICHER  LOW-TEIL 
F_SPEICHER_H            EQU     0X33    ;FLASH-SPEICHER HIGH-TEIL                       
ZAE_XX                  EQU     0X34    ;UEBERLAUF NACH UNTEN UNTERHALB ZB: 0X0800 ALSO 0X07FE...
                                        ;WEGEN LED ANZEIGEN AM ENDE ROT VON FESTTEXT
SPEICHER_H              EQU     0X37    ;ZUM SPEICHERN DER ADRESSE WANN ROTE LED AM SCHLUSS LEUCHTEN SOLL
SPEICHER_L              EQU     0X38    ;ZUM SPEICHERN DER ADRESSE WANN ROTE LED AM SCHLUSS LEUCHTEN SOLL             
                                        ;AUCH FUER "AUSWERTUNG" WANN ROTE LED AM SCHLUSS LEUCHTEN SOLL
                                        
;ACHTUNG AUF ADRESSE=0X801 AB WANN ROT LEUCHTEN //AB ADRESSE 0X802 CW-DATEN                             
MERK_SPEICHER_H         EQU     0X39    ;WEGEN UEBERLAUF VON Z.B.: 0X0800 ZU 0X0900 DIE 0X0800 MERKEN
UEBERLAUF               EQU     0X3A
HELP_SPEICHER_H         EQU     0X3B    ;BEI ROT-BEGINN AUSLESEN HIGH-TEIL                  
HELP_ROT                EQU     0X3C    ;WEGEN ROT ZWISCHEN 0X0800 AM ENDE VOR FF BIS BER 0X0900 KURZ DRBER
                
;------------------------- PROGRAMM ----------------------------------------------
        ORG 0X0000
        GOTO MAIN                       ; SPRUNG ZUM HAUPTPROGRAMM
        ORG 0X0004
        RETFIE                          ; BEI EINEM INTERRUPT SOFORT EIN RETURN

        ORG 0X0010
;*****************************************************************************
;*                              HAUPTPROGRAMM                                *
;*****************************************************************************
MAIN
;----------- INIT ALLE PORT'S ----------------------------------------------------
                CLRF    PORTA           ;ANFANGSZUSTAND
                CLRF    PORTB       
                CLRF    PORTC

                BANK1
;AD
                MOVLW   B'10001110'     ;NUR RA0/AN0 POTI-TEMPO MIT AD-WANDLUNG SONST ALLES DIGITALE I/O  //AD-WERT RECHTS-BUENDIG 
                MOVWF   ADCON1          ;ADMF=1 RECHTSBNDIG, VDD ALS REF, CHANNEL AN0

                MOVLW   B'11111111'     ;INIT I/O PORT A --> ALLES EINGAENGE MIT RA0/AN0 POTI-TEMPO 
                MOVWF   TRISA

;EING.  PORTB   RB7 PADDEL PUNKT
;EING.  PORTB   RB6 PADDEL STRICH
;EING.  PORTB   RB5 TASTER TEXT5
;EING.  PORTB   RB4 TASTER TEXT4
;EING.  PORTB   RB3 TASTER TEXT3
;EING.  PORTB   RB2 TASTER TEXT2      
;EING.  PORTB   RB1 TASTER TEXT1
;EING.  PORTB   RB0 TASTER TEXT0
                MOVLW   B'11111111'     ;INIT I/O PORT B --> ALLES EINGAENGE MIT PADDLE UND PUNKT/STRICH SIEHE OBEN 
                MOVWF   TRISB

;AUSG.  PORTC   RC0 CW AUSGANG 
;AUSG.  PORTC   RC1 LED GN FUER PROGRAMMIEREN
;AUSG.  PORTC   RC2 LED RT FUER CW-ENDE
;AUSG.  PORTC   RC3 LED GN FUER CW-NORMAL
;EING.  PORTC   RC4 SCHALTER PROGRAMMIEREN FESTTEXT
;EING.  PORTC   RC5 FREI
;EING.  PORTC   RC6 FREI
;AUSG.  PORTC   RC7 MITHOERTON AUSGANG
                MOVLW   B'01110000'     ;INIT I/O PORT C 
                MOVWF   TRISC
;INIT TIMER0            
                MOVLW   B'10000111'     ;RBPU DISABLE[1], INTEDG EGAL [0], T0CS INTERNAL CLOCK [0], PSA FUER TIMER0 [0], PRESCALE1:256 + SYSTEMCLOCK T/4 [111]
                MOVWF   OPTION_REG      
                BANK0
;INIT TIMER 1 
                MOVLW   B'00110000'     ;BIT0 STOP-TIMER [0], BIT1 INTERNAL CLOCK [0], BIT2 EGAL [0], BIT3 OSZIL. OFF [0], BIT4-5 PRESCALER ALLES [11]1:8 BEI 8MHZ
                MOVWF   T1CON
;AD             
                MOVLW   B'00000001'     ;INIT 2*TOSC [00]!!!! HIER GEAENDERT VON [01] !!!!, AN0 [000], GO_DONE [0], NICHT BELEGT [0], ADON [1] KANN AUCH EINS SEIN ADON IN UNTERPRG.
                MOVWF   ADCON0
;ALLE LEDS AUS          
                BSF     PORTC, LED_GN_PROG
                BSF     PORTC, LED_GN_CW
                BSF     PORTC, LED_RT_ENDE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;---------------VOLLKOMMEN--INITIALISIERUNG--ZU--ENDE---------------------------
                    MOVLW   D'10'          ;ZEITSCHLEIFE FUER 200MSEC EINGESTELLT
                    CALL    ZS20MSEC       ;UM EINSCHALTIMPULS ZU UNTERDRUECKEN

                    CLRF    STRPKT

ANFANG              BSF     PORTC, LED_GN_PROG  ;LED LEUCHTET NICHT
                    
                    BSF     STRPKT, BIT6    ;SETZEN FR DAS PADDLE MORSEN
                    BCF     STRPKT, BIT4

                    BTFSS   PORTB, CW_STRICH       ;STRICH GEDRCKT?
                    CALL    STRICH          ;WENN JA STRICH MORSEN

                    BTFSS   PORTB, CW_PUNKT       ;PUNKT GEDRCKT?
                    CALL    PUNKT           ;WENN JA PUNKT MORSEN

                    BTFSC   STRPKT, BIT7    ;WENN STRICH MERKER GESETZT
                    CALL    STRICH          ;STRICH MORSEN

                    BTFSC   STRPKT, BIT0    ;WENN PUNKT MERKER GESETZT
                    CALL    PUNKT           ;PUNKT MORSEN
;-------------
BLINK1              BTFSC   PORTC, PROGRAMMIEREN       ;PROGRAMMIER-SCHALTER FUER FESTTEXT ABFRAGEN -HIGH AKTIV
                    GOTO    BLINK
                    GOTO    ABSPIEL ;ZU ABSPIEL ABFRAGE
                    ;GOTO    ANFANG BEI ABSPIEL ZU ANFANG
;------------
BLINK               BCF     PORTC, LED_GN_PROG  ;LED LEUCHTET 
                    MOVLW   D'30'               ;300MSEC ZEITSCHLEIFE
                    CALL    ZS10MSEC_SCHALTER_TASTER
                    BTFSC   ABFRAGE, BIT0
                    GOTO    BLINK_ENDE              
                    
                    BTFSS   PORTC, PROGRAMMIEREN       ;PROGRAMMIER-SCHALTER FUER FESTTEXT ABFRAGEN -HIGH AKTIV
                    GOTO    BLINK1
                    
                    
                    BSF     PORTC, LED_GN_PROG  ;LED LEUCHTET NICHT 
                    MOVLW   D'30'               ;300MSEC ZEITSCHLEIFE
                    CALL    ZS10MSEC_SCHALTER_TASTER
                    BTFSC   ABFRAGE, BIT0
                    GOTO    BLINK_ENDE
                    
                    BTFSS   PORTC, PROGRAMMIEREN       ;PROGRAMMIER-SCHALTER FUER FESTTEXT ABFRAGEN -HIGH AKTIV
                    GOTO    BLINK1
                    
                    GOTO    BLINK
;-------------
;TASTER 0 BIS 5 ABFRAGE UND PROGRAMMIER-SCHALTER DENNOCH ZURCK SCHALTEN                    
BLINK_ENDE          BCF     ABFRAGE, BIT0    
                    BTFSC   PORTC, PROGRAMMIEREN        ;SCHALTER FR FESTTEXT ABFRAGEN HIGH AKTIV
                    GOTO    ABFRAG01                    ;HIER PROGRAMMIER-SCHALTER AKTIV
                    
                    BSF     PORTC, LED_GN_PROG          ;LED LEUCHTET NICHT MEHR -PROGRAMMIER-SCHALTER NICHT AKTIV BEI LOW
                    GOTO    ANFANG                      ;ZURUECK ZU NORMAL MORSEN
;---------------------------------------
;FUER ABSPIELEN DIE ADRESSEN                
ABSPIEL             BTFSC   PORTB, FESTTEXT0    
                    GOTO    AABFRAG02
                    MOVLW   0X08
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    TXT1
                                    
AABFRAG02           BTFSC   PORTB, FESTTEXT1    
                    GOTO    AABFRAG03
                    MOVLW   0X0A
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    TXT1
                                    
AABFRAG03           BTFSC   PORTB, FESTTEXT2    
                    GOTO    AABFRAG04
                    MOVLW   0X0C
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    TXT1
                                    
AABFRAG04           BTFSC   PORTB, FESTTEXT3    
                    GOTO    AABFRAG05
                    MOVLW   0X0E
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    TXT1
                                    
AABFRAG05           BTFSC   PORTB, FESTTEXT4    
                    GOTO    AABFRAG06
                    MOVLW   0X10
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    TXT1
                                    
AABFRAG06           BTFSC   PORTB, FESTTEXT5    
                    GOTO    ANFANG
                    MOVLW   0X12
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    TXT1
;-------------    
;-------------
;FUER ABSPEICHERN DIE ADRESSEN              
ABFRAG01            BCF     PORTC, LED_GN_PROG          ;PROGRAMMIER-LED LEUCHTET DAUERND
                    
                    BTFSC   PORTB, FESTTEXT0    
                    GOTO    ABFRAG02
                    MOVLW   0X08
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    KENNUNG
                                    
ABFRAG02            BTFSC   PORTB, FESTTEXT1    
                    GOTO    ABFRAG03
                    MOVLW   0X0A
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    KENNUNG
                                    
ABFRAG03            BTFSC   PORTB, FESTTEXT2    
                    GOTO    ABFRAG04
                    MOVLW   0X0C
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    KENNUNG
                                    
ABFRAG04            BTFSC   PORTB, FESTTEXT3    
                    GOTO    ABFRAG05
                    MOVLW   0X0E
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    KENNUNG
                                    
ABFRAG05            BTFSC   PORTB, FESTTEXT4    
                    GOTO    ABFRAG06
                    MOVLW   0X10
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H 
                    GOTO    KENNUNG
                                    
ABFRAG06            BTFSC   PORTB, FESTTEXT5    
                    GOTO    BLINK_ENDE
                    MOVLW   0X12
                    MOVWF   F_SPEICHER_H
                    MOVWF   MERK_SPEICHER_H
;-------------
;DAS "SAVE" FR SPEICHERN MORSEN
KENNUNG             CALL    PUNKT   ;S                   
                    CALL    PUNKT
                    CALL    PUNKT
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY
                    CALL    PUNKT   ;A
                    CALL    STRICH
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY
                    CALL    PUNKT   ;V
                    CALL    PUNKT
                    CALL    PUNKT
                    CALL    STRICH
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY                   
                    CALL    PUNKT   ;E

                    MOVLW   D'2'
                    MOVWF   UEBERLAUF   ;UEBERLAUF 
                    CLRF    MERK2
                    CLRF    ABFRAGE
                    CLRF    ADR_MERK
;-------------------
;-------------------
;SPEICHERN MITTELS PADDLE

;ERST BEIM ERSTEN PADDLE-DRUCK SPEICHERN
PAD                 BTFSS   PORTB, CW_STRICH       ;STRICH
                    GOTO    AA0
                    BTFSS   PORTB, CW_PUNKT       ;PUNKT
                    GOTO    AA0
;SPEICHERN BEENDEN
;MITTELS TASTER GLEICH AM ANFANG
                    ;BCF     ABFRAGE, BIT0
                    ;CALL    BEENDEN
                    ;BTFSS   ABFRAGE, BIT0
                    ;GOTO    PAD
                    ;GOTO    WEITER3 ;SCHLUSS ABSPEICHERN
                    BTFSC   PORTC, PROGRAMMIEREN       ;MITTELS TASTER 
                    GOTO    PAD
                    GOTO    WEITER3 ;SCHLUSS ABSPEICHERN
;---------

AA0                 MOVLW   D'2'                    ;VON Z.B.: 0X0800 BIS 0X0900 IN SPEICHERN F_WRITE
                    MOVWF   UEBERLAUF
                    
                    CLRF    STRPKT
                    CLRF    F_SPEICHER_L            ;ADRESSE 0X00 HIER AM SCHLUSS ENDE-LEUCHTEN DER ROTEN LED
                    
                    INCF    F_SPEICHER_L, F         ;AB 0X01 KOMMT AB WANN ROT LEUCHTEN AM ENDE 
                    
                    INCF    F_SPEICHER_L, F         ;AB ADRESSE 0X02 CW-DATEN SPEICHERN
                    
                    CLRF    SP_BYTE                 ;ZU SPEICHERNDES BYTE MIT 0X00
                    CLRF    ZAEHLER

                    BSF     STRPKT, BIT6    ;SETZEN FR DAS PADDLE MORSEN
                    BCF     STRPKT, BIT4
                    BCF     STRPKT, BIT2    ;BERLAUFMERKER AUS

;STRICH
SP_BEGIN            BCF     ABFRAGE, BIT0
                    CALL    BEENDEN
                    BTFSC   ABFRAGE, BIT0
                    ;BTFSC   MERK2, BIT0
                    GOTO    WEITER3

                    BTFSC   PORTB, CW_STRICH       ;STRICH GEDRCKT?
                    GOTO    AA2
                    CALL    STRICH          ;WENN JA STRICH MORSEN
                    BSF     SP_BYTE, BIT7   ;UND SPEICHERN
                    RRF     SP_BYTE, F
                    INCF    ZAEHLER, F
                    
                MOVLW   D'7'
                SUBWF   ZAEHLER, W
                BTFSS   STATUS, Z
                GOTO    AA2

                BSF     SP_BYTE, BIT7
                MOVF    SP_BYTE, W
                CALL    F_WRITE
                CLRF    SP_BYTE
                INCF    F_SPEICHER_L, F

                MOVF    ZAEHLER, W
                CALL    F_WRITE
                CLRF    ZAEHLER
                INCF    F_SPEICHER_L, F

;PUNKT
AA2                 BTFSC   PORTB, CW_PUNKT       ;PUNKT GEDRCKT?
                    GOTO    AA3
                    CALL    PUNKT           ;WENN JA PUNKT MORSEN
                    BCF     SP_BYTE, BIT7   ;UND SPEICHERN
                    RRF     SP_BYTE, F
                    INCF    ZAEHLER, F
                    
                MOVLW   D'7'
                SUBWF   ZAEHLER, W
                BTFSS   STATUS, Z
                GOTO    AA3

                BSF     SP_BYTE, BIT7
                MOVF    SP_BYTE, W
                CALL    F_WRITE
                CLRF    SP_BYTE
                INCF    F_SPEICHER_L, F

                MOVF    ZAEHLER, W
                CALL    F_WRITE
                CLRF    ZAEHLER
                INCF    F_SPEICHER_L, F

;STRICH
AA3                 BTFSS   STRPKT, BIT7    ;WENN STRICH MERKER GESETZT
                    GOTO    AA4
                    CALL    STRICH          ;STRICH MORSEN
                    BSF     SP_BYTE, BIT7   ;UND SPEICHERN
                    RRF     SP_BYTE, F
                    INCF    ZAEHLER, F
                    
                MOVLW   D'7'
                SUBWF   ZAEHLER, W
                BTFSS   STATUS, Z
                GOTO    AA4

                BSF     SP_BYTE, BIT7
                MOVF    SP_BYTE, W
                CALL    F_WRITE
                CLRF    SP_BYTE
                INCF    F_SPEICHER_L, F

                MOVF    ZAEHLER, W
                CALL    F_WRITE
                CLRF    ZAEHLER
                INCF    F_SPEICHER_L, F

;PUNKT
AA4                 BTFSS   STRPKT, BIT0    ;WENN PUNKT MERKER GESETZT
                    GOTO    SP
                    CALL    PUNKT           ;PUNKT MORSEN
                    BCF     SP_BYTE, BIT7   ;UND SPEICHERN
                    RRF     SP_BYTE, F
                    INCF    ZAEHLER, F
                    
                MOVLW   D'7'
                SUBWF   ZAEHLER, W
                BTFSS   STATUS, Z
                GOTO    SP

                BSF     SP_BYTE, BIT7
                MOVF    SP_BYTE, W
                CALL    F_WRITE
                CLRF    SP_BYTE
                INCF    F_SPEICHER_L, F

                MOVF    ZAEHLER, W
                CALL    F_WRITE
                CLRF    ZAEHLER
                INCF    F_SPEICHER_L, F

SP              CALL    SP_PAUSE

;--------
;SPEICHERBERLAUF KEIN TON DANN OK MORSEN 
                    BTFSS   STRPKT, BIT2
                    GOTO    ABFRAGE2
                    MOVLW   D'10'
                    MOVWF   ZAEHLER
WEITER8             CALL    DELAY
                    DECFSZ  ZAEHLER, F
                    GOTO    WEITER8
                    GOTO    WEITER3
;--------
;TASTERABFRAGE BEENDEN
ABFRAGE2            BCF     ABFRAGE, BIT0
                    CALL    BEENDEN
                    BTFSC   ABFRAGE, BIT0
                    ;BTFSC   MERK2, BIT0
                    GOTO    WEITER3
                    ;BTFSC   PORTC, PROGRAMMIEREN
                    GOTO    SP_BEGIN

;-------------
;DAS OK MORSEN UND ENDEBYTES ABSPEICHERN
WEITER3             CLRF    MERK2
                    CLRF    ABFRAGE
                    
                MOVLW   0X00               ;KEINE PADDLE-TASTE BETTIGT IMMER NOCH AUF ADRESSE 0X00
                SUBWF   ADR_MERK, W        ;KEINE ENDEBYTE SPEICHERN
                BTFSC   STATUS, Z
                GOTO    WEITER11

                    MOVF    ADR_MERK, W   ;ENDEBYTE OHNE PAUSE
                    MOVWF   F_SPEICHER_L
                    MOVLW   0XFF
                    CALL    F_WRITE
                    INCF    F_SPEICHER_L, F
                    MOVLW   0XFF
                    CALL    F_WRITE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;BEI UEBERLAUF DAUERTON UND ERROR MORSEN
                    BTFSS   STRPKT, BIT2
                    GOTO    VV00
                    
                    CALL    EIN
                    MOVLW   D'150'      ;3SEC DAUERTON
                    CALL    ZS20MSEC
                    CALL    AUS
                    
                    CALL    DELAY       
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY       
                    CALL    DELAY
                    CALL    DELAY
                    
                    CALL    PUNKT       ;E   ERROR MORSEN
                    CALL    DELAY       
                    CALL    DELAY
                    CALL    DELAY
                    CALL    PUNKT       ;R
                    CALL    STRICH
                    CALL    PUNKT
                    CALL    DELAY       
                    CALL    DELAY
                    CALL    DELAY
                    CALL    PUNKT       ;R
                    CALL    STRICH
                    CALL    PUNKT
                    CALL    DELAY       
                    CALL    DELAY
                    CALL    DELAY
                    CALL    STRICH      ;O
                    CALL    STRICH
                    CALL    STRICH
                    CALL    DELAY       
                    CALL    DELAY
                    CALL    DELAY
                    CALL    PUNKT       ;R
                    CALL    STRICH
                    CALL    PUNKT
                    
                    CALL    DELAY       
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY       
                    CALL    DELAY
                    CALL    DELAY
                    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;ROTE LED SOLL Z.B.: 20... ZEICHEN VOR ENDE LEUCHTEN
VV00                MOVLW   LED_VORHER
                    MOVWF   ZAE_XX
                    
                    MOVF    F_SPEICHER_L, W
                    MOVWF   SPEICHER_L
                    MOVF    F_SPEICHER_H, W
                    MOVWF   SPEICHER_H
                    
;BEI Z.B.: 0X0800                    
                    MOVF    F_SPEICHER_H, W         
                    SUBWF   MERK_SPEICHER_H, W
                    BTFSS   STATUS, Z
                    GOTO    VV24
;BEI Z.B.: 0X0800                    
VV01                DECFSZ  SPEICHER_L, F
                    GOTO    VV03
                    CLRF    SPEICHER_L
                    GOTO    VV02
VV03                DECFSZ  ZAE_XX, F
                    GOTO    VV01
                    
VV02                CALL    F_WRITE_1
                    GOTO    WEITER11
                    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;; 
;BEI Z.B.:0X0900                             
VV24                DECF    SPEICHER_L, F
                    MOVF    SPEICHER_L, W
                    SUBLW   0XFF            ;BEI 0X09FF ZU 0X08FF
                    BTFSS   STATUS, Z
                    GOTO    VV23
                    DECF    SPEICHER_H, F
                    ;CLRF    SPEICHER_L
                    ;GOTO    VV22
VV23                DECFSZ  ZAE_XX, F
                    GOTO    VV24
                    
VV22                CALL    F_WRITE_1
                    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;     
WEITER11            CALL    STRICH      ;MORSEN OK
                    CALL    STRICH
                    CALL    STRICH
                    CALL    DELAY       ;ZWISCHEN DEN ZEICHEN DIE PAUSE
                    CALL    DELAY
                    CALL    DELAY
                    CALL    STRICH
                    CALL    PUNKT
                    CALL    STRICH
                    
                    BCF     ABFRAGE, BIT0
                    GOTO    ANFANG


;-------------
;FESTTEXT MORSEN AUSGABE
TXT1                BCF     STRPKT, BIT6    ;PADDLE MORSEN AUSSCHALTEN
                    BCF     STRPKT, BIT5    ;BAKE-MORSEN AUSSCHALTEN
                    BSF     STRPKT, BIT4    ;TEXT MORSEN EINSCHALTEN
                    
T1                  MOVF    MERK_SPEICHER_H, W
                    MOVWF   F_SPEICHER_H
                    
                    CLRF    F_SPEICHER_L             ;ADRESSE AUF START SETZEN
                    INCF    F_SPEICHER_L, F          ;HIER 0X01 HIER STEHT AB WANN ROT LEUCHTEN FR ENDE
                    CALL    F_READ
                    MOVWF   SPEICHER_L               ;FUER AUSWERTUNG WANN ROTE LED AM SCHLUSS LEUCHTEN SOLL /// NUR LOW-TEIL --->HIGH TEIL IN HELP_SPEICHER_H
                    MOVF    HELP_SPEICHER_H, W
                    MOVWF   SPEICHER_H
                    BCF     HELP_ROT, BIT0                  
                    
                    INCF    F_SPEICHER_L, F          ;ES BEGINNT AB 0X02 MIT DEN CW-DATEN

AUSL                CALL    F_READ
                    MOVWF   CW

                    BTFSS   CW, BIT7
                    GOTO    PAUS

                    INCF    F_SPEICHER_L, F
                    CALL    F_READ
                    MOVWF   ANZ

                    MOVLW   0XFF                ;ENDEERKENNUNG BEIM ERSTEN AUSLESEN
                    SUBWF   ANZ, W
                    BTFSC   STATUS, Z
                    GOTO    TENDE
                    GOTO    T0

PAUS                CALL    CW_PAUSE
                    INCF    F_SPEICHER_L, F
                    GOTO    AUSL

;---
;MORSEN
T0                  MOVLW   D'7'
                    SUBWF   ANZ, W
                    BTFSC   STATUS, Z
                    GOTO    T2
                    
                    MOVF    ANZ, W
                    SUBLW   D'7'
                    MOVWF   TXT_ZAE
T5                  RRF     CW, F
                    DECFSZ  TXT_ZAE, F
                    GOTO    T5
                    
T2                  BTFSS   CW, BIT0
                    GOTO    T3
                    CALL    STRICH
                    BTFSS   STRPKT, BIT4
                    GOTO    PKT_WEG
                    RRF     CW, F
                    DECFSZ  ANZ, F
                    GOTO    T2
                    GOTO    TX1

T3                  CALL    PUNKT
                    BTFSS   STRPKT, BIT4
                    GOTO    PKT_WEG
                    RRF     CW, F
                    DECFSZ  ANZ, F
                    GOTO    T2

TX1                 INCF    F_SPEICHER_L, F
                    GOTO    AUSL



;BAKEN-WIEDERHOLUNG UND 0XFF ENDEERKENNUNG
TENDE               MOVF    F_SPEICHER_L, W
                    SUBLW   0X01
                    BTFSC   STATUS, Z
                    GOTO    ANFANG

                    BTFSS   STRPKT, BIT5
                    GOTO    PKT_WEG
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY
                    CALL    DELAY
                    GOTO    T1

;PUNKT AUSBLENDEN BEI ABBRUCH MIT ENTPRELLUNG
PKT_WEG             MOVLW   D'200'          ;20MSEC JETZT // VORHER 1MSEC MIT 100 UND 10
                    MOVWF   ZAE1

PKT_W               BTFSS   PORTB, CW_PUNKT
                    GOTO    PKT_WEG
                    MOVLW   D'100'
                    CALL    ZSMUE
                    DECFSZ  ZAE1, F
                    GOTO    PKT_W
                    
                    BSF     PORTC, LED_GN_CW   ;LEUCHTET NICHT 
                    BSF     PORTC, LED_RT_ENDE ;LEUCHTET NICHT
                    GOTO    ANFANG

;*****************************************************************************
;*                              PAUSE BEIM FESTTEXT AUSGEBEN                 *
;*****************************************************************************
CW_PAUSE        BTFSC   STRPKT, BIT6
                GOTO    CII1
                BTFSC   STRPKT, BIT4
                GOTO    CII1
                RETURN

CII1            BCF     PIR1, ADIF
                ;BSF     ADCON0, ADON
                ;MOVLW   D'5'
                ;CALL    ZSMUE
                BSF     ADCON0, GO_DONE     ;GEHT LOS
                MOVLW   D'5'
                CALL    ZSMUE               ;ZEITSCHLEIFE

CIII            BTFSS  PIR1, ADIF
                GOTO   CIII

;ANALOG/DIGITAL-WANDLUNG STOPPEN
                ;BCF     ADCON0, ADON        
                BCF     ADCON0, GO_DONE    


;AD-ERGEBNIS ABSPEICHERN IN RAM-ZELLEN
                        MOVF    ADRESH, W
                        MOVWF   AD_H
                        BANK1
                        MOVF    ADRESL, W
                        BANK0
                        MOVWF   AD_L

;BERECHNUNG
                        MOVLW   0X54        ;+340DEZ  // ALSO==>(0X0154)+AD
                        ADDWF   AD_L, F     
                        BTFSS   STATUS, C   
                        GOTO    CT221

                        INCF    AD_H, F
CT221                   INCF    AD_H, F

;SUBTRAKTION VON 0XFFFF
                        MOVF    AD_L, W     ;AD --> W
                        SUBLW   0XFF        ;0XFF-W  --> W
                        MOVWF   AD_L        ;W       --> AD_L

                        MOVF    AD_H, W     ;AD0WERT --> W
                        SUBLW   0XFF        ;0XFF-W  --> W
                        MOVWF   AD_H        ;W       --> AD_H


CD0Y            MOVLW   D'16'
                MOVWF   MERK

CD02            BCF     T1CON, TMR1ON   ;STOP DES TIMER1

                MOVF    AD_L, W        
                MOVWF   TMR1L       
                MOVF    AD_H, W
                MOVWF   TMR1H

                BCF     PIR1, TMR1IF    ;OVERFLOW 0 MACHEN

                BSF     T1CON, TMR1ON   ;START DES TIMER1


CD01            BTFSS   STRPKT, BIT6    ;FESTTEXT MODUS 1X GESTARTET
                GOTO    CD03

                BTFSS   PORTB, CW_STRICH       ;STRICH-MERKER
                BSF     STRPKT, BIT7

                BTFSS   PORTB, CW_PUNKT       ;PUNKT-MERKER
                BSF     STRPKT, BIT0
                GOTO    CD0X

CD03            BTFSS   PORTB, CW_STRICH       ;STRICH-MERKER FR FESTTEXT ALLES WIEDERHOLEN
                BSF     STRPKT, BIT5

                BTFSC   PORTB, CW_PUNKT       ;PUNKT-MERKER -ENDE DES FESTTEXT ALSO SOFORT ABBRUCH
                GOTO    CD0X
                BCF     STRPKT, BIT5
                BCF     STRPKT, BIT4
                BCF     T1CON, TMR1ON   ;STOP DES TIMER1
                CALL    AUS
                RETURN

CD0X            BTFSS   PIR1, TMR1IF
                GOTO    CD01

                DECFSZ  MERK, F
                GOTO    CD02

                DECFSZ  CW, F
                GOTO    CD0Y

                BCF     T1CON, TMR1ON   ;STOP DES TIMER1
                RETURN


;*****************************************************************************
;*                              PAUSE ABSPEICHERN                            *
;*****************************************************************************
SP_PAUSE            CLRF    ZAEHLER1

                    BTFSS   PORTB, CW_STRICH       ;STRICH
                    RETURN
                    BTFSS   PORTB, CW_PUNKT       ;PUNKT
                    RETURN
                    BTFSC   STRPKT, BIT7    ;STRICHMERKER   
                    RETURN
                    BTFSC   STRPKT, BIT0    ;PUNKTMERKER
                    RETURN

                    ;BCF            ABFRAGE, BIT0
                    ;CALL    BEENDEN
                    ;BTFSC   ABFRAGE, BIT0
                    BTFSC   MERK2, BIT0
                    RETURN
                    
                    BCF     ABFRAGE, BIT0
                    CALL    BEENDEN
                    ;BTFSC   PORTC, PROGRAMMIEREN       ;MITTELS TASTER 
                    BTFSS   ABFRAGE, BIT0
                    GOTO    SP_P
                    BSF     MERK2, BIT0
                    RETURN

;-----
;BEI ZAEHLER GRER NULL NUR SPEICHERN
SP_P            MOVF    ZAEHLER, W ;SP_BYTE, W
                SUBLW   D'0'
                BTFSS   STATUS, Z
                GOTO    SA
                GOTO    SI  ;RETURN

SA              BSF     SP_BYTE, BIT7
                MOVF    SP_BYTE, W
                CALL    F_WRITE
                CLRF    SP_BYTE
                INCF    F_SPEICHER_L, F

                MOVF    ZAEHLER, W
                CALL    F_WRITE
                CLRF    ZAEHLER
                INCF    F_SPEICHER_L, F

;--------
;ENDE F_SPEICHER_L MERKEN FR ENDEKENNUNG
                MOVF    F_SPEICHER_L, W             ;INCF
                MOVWF   ADR_MERK

;----------TIMER+AD INIT
SI              BCF     PIR1, ADIF

;ANALOG/DIGITAL-WANDLUNG STARTEN
                ;BSF     ADCON0, ADON        ;SETZT SICH AUTOMATISCH WENN AD-WANDLUNG ERFOLGT
                ;MOVLW   D'5'
                ;CALL    ZSMUE               ;ZEITSCHLEIFE
                BSF     ADCON0, GO_DONE     ;GEHT LOS
                MOVLW   D'5'
                CALL    ZSMUE               ;ZEITSCHLEIFE

SIII            BTFSS  PIR1, ADIF
                GOTO   SIII

;ANALOG/DIGITAL-WANDLUNG STOPPEN
                ;BCF     ADCON0, ADON        
                BCF     ADCON0, GO_DONE    


;AD-ERGEBNIS ABSPEICHERN IN RAM-ZELLEN
                        MOVF    ADRESH, W
                        MOVWF   AD_H
                        BANK1
                        MOVF    ADRESL, W
                        BANK0
                        MOVWF   AD_L

;BERECHNUNG
                        MOVLW   0X54        ;+340DEZ  // ALSO==>(0X0154)+AD
                        ADDWF   AD_L, F     
                        BTFSS   STATUS, C   
                        GOTO    ST221

                        INCF    AD_H, F
ST221                   INCF    AD_H, F

;SUBTRAKTION VON 0XFFFF
                        MOVF    AD_L, W     ;AD --> W
                        SUBLW   0XFF        ;0XFF-W  --> W
                        MOVWF   AD_L        ;W       --> AD_L

                        MOVF    AD_H, W     ;AD0WERT --> W
                        SUBLW   0XFF        ;0XFF-W  --> W
                        MOVWF   AD_H        ;W       --> AD_H


SIF             MOVLW   D'16'
                MOVWF   MERK

SD02            BCF     T1CON, TMR1ON   ;STOP DES TIMER1

                MOVF    AD_L, W        
                MOVWF   TMR1L       
                MOVF    AD_H, W
                MOVWF   TMR1H

                BCF     PIR1, TMR1IF    ;OVERFLOW 0 MACHEN

                BSF     T1CON, TMR1ON   ;START DES TIMER1

SD01            BTFSS   PORTB, CW_STRICH       ;STRICH
                GOTO    SD03
                BTFSS   PORTB, CW_PUNKT       ;PUNKT
                GOTO    SD03

                    BTFSS   ABFRAGE, BIT0
                    ;BTFSS   MERK2, BIT0
                    GOTO    SD05
                    BCF     T1CON, TMR1ON   ;STOP DES TIMER1
                    RETURN

SD05                BCF     ABFRAGE, BIT0
                    CALL    BEENDEN
                    BTFSS   ABFRAGE, BIT0
                    ;BTFSC   PORTC, PROGRAMMIEREN       ;MITTELS TASTER 
                    GOTO    SD04
                    BSF     MERK2, BIT0
                    BCF     T1CON, TMR1ON   ;STOP DES TIMER1
                    RETURN

SD04            BTFSS   PIR1, TMR1IF
                GOTO    SD01

                DECFSZ  MERK, F
                GOTO    SD02

                INCF    ZAEHLER1, F
                    
                MOVLW   0X7F
                SUBWF   ZAEHLER1, W
                BTFSS   STATUS, Z
                GOTO    SIF

                BCF     ZAEHLER1, BIT7
                MOVF    ZAEHLER1, W
                CALL    F_WRITE
;                CLRF    ZAEHLER1
                INCF    F_SPEICHER_L, F
                BCF     T1CON, TMR1ON   ;STOP DES TIMER1
                RETURN

SD03            BCF     T1CON, TMR1ON   ;STOP DES TIMER1

;-----
;BEI ZAEHLER GRER NULL NUR SPEICHERN
SD06            MOVF    ZAEHLER1, W
                SUBLW   D'0'
                BTFSC   STATUS, Z
                RETURN

                BCF     ZAEHLER1, BIT7
                MOVF    ZAEHLER1, W
                CALL    F_WRITE
;                CLRF    ZAEHLER1
                INCF    F_SPEICHER_L, F
                RETURN

;*****************************************************************************
;*                              DELAY ZEIT FUER TEMPO                        *
;*****************************************************************************
DELAY           BTFSC   STRPKT, BIT6
                GOTO    II1
                BTFSC   STRPKT, BIT4
                GOTO    II1
                RETURN

II1             BCF     PIR1, ADIF

;ANALOG/DIGITAL-WANDLUNG STARTEN
                ;BSF     ADCON0, ADON        ;SETZT SICH AUTOMATISCH WENN AD-WANDLUNG ERFOLGT
                ;MOVLW   D'5'
                ;CALL    ZSMUE               ;ZEITSCHLEIFE
                BSF     ADCON0, GO_DONE     ;GEHT LOS
                MOVLW   D'5'
                CALL    ZSMUE               ;ZEITSCHLEIFE

III             BTFSS  PIR1, ADIF
                GOTO   III

;ANALOG/DIGITAL-WANDLUNG STOPPEN
                ;BCF     ADCON0, ADON        
                BCF     ADCON0, GO_DONE    


;AD-ERGEBNIS ABSPEICHERN IN RAM-ZELLEN
                        MOVF    ADRESH, W
                        MOVWF   AD_H
                        BANK1
                        MOVF    ADRESL, W
                        BANK0
                        MOVWF   AD_L

;BERECHNUNG
                        MOVLW   0X54        ;+340DEZ  // ALSO==>(0X0154)+AD
                        ADDWF   AD_L, F     
                        BTFSS   STATUS, C   
                        GOTO    T221

                        INCF    AD_H, F
T221                    INCF    AD_H, F

;SUBTRAKTION VON 0XFFFF
                        MOVF    AD_L, W     ;AD --> W
                        SUBLW   0XFF        ;0XFF-W  --> W
                        MOVWF   AD_L        ;W       --> AD_L

                        MOVF    AD_H, W     ;AD0WERT --> W
                        SUBLW   0XFF        ;0XFF-W  --> W
                        MOVWF   AD_H        ;W       --> AD_H


                MOVLW   D'32'
                MOVWF   MERK

D02             BCF     T1CON, TMR1ON   ;STOP DES TIMER1

                MOVF    AD_L, W        
                MOVWF   TMR1L       
                MOVF    AD_H, W
                MOVWF   TMR1H

                BCF     PIR1, TMR1IF    ;OVERFLOW 0 MACHEN

                BSF     T1CON, TMR1ON   ;START DES TIMER1


D01             BTFSS   STRPKT, BIT6    ;FESTTEXT MODUS 1X GESTARTET
                GOTO    D03

                BTFSS   PORTB, CW_STRICH       ;STRICH-MERKER
                BSF     STRPKT, BIT7

                BTFSS   PORTB, CW_PUNKT       ;PUNKT-MERKER
                BSF     STRPKT, BIT0
                GOTO    D0X

D03             BTFSS   PORTB, CW_STRICH       ;STRICH-MERKER FR FESTTEXT ALLES WIEDERHOLEN
                BSF     STRPKT, BIT5

                BTFSC   PORTB, CW_PUNKT       ;PUNKT-MERKER -ENDE DES FESTTEXT ALSO SOFORT ABBRUCH
                GOTO    D0X
                BCF     STRPKT, BIT5
                BCF     STRPKT, BIT4
                BCF     T1CON, TMR1ON   ;STOP DES TIMER1
                CALL    AUS
                RETURN

D0X             BTFSS   PIR1, TMR1IF
                GOTO    D01

                DECFSZ  MERK, F
                GOTO    D02
                BCF     T1CON, TMR1ON   ;STOP DES TIMER1
                RETURN


;*****************************************************************************
;*                          BERECHNUNG FUER TEMPO                             *
;*****************************************************************************
;VORRAUSETZUNG 54MSEC==90ZPM FUER EINE EINHEIT VON DELAY

;MIT PROPORTION ZU 60ZPM ERGEBEN SICH 81MSEC FR EINE EIHEIT VON DELAY

;ES WIRD TIMER 1 GENOMMEN, DA ER AUCH BEI DER AD-WANDLUNG MIT DER TEMPOEINSTELLUNG
;VERWENDET WERDEN SOLL

;TIMER 1 WIRD 32MAL DURCHLAUFEN
;81MSEC : 32 = 2,531MSEC MUSS TIMER 1 BEI TMR1L + TMR1H EINGESTELLT SEIN

;TEILER 1:4(PRESCALER) UND OSZI 1:4 ==>1:16
;16*0.25S=4S

;2,531MSEC : 4SEC = 632 MAL ==278HEX
;0XFFFF - 0X0278 = 0XFD87

;ALSO
;TMR1L=0X87
;TMR1H=0XFD

;---------------------------------------------------------------------------------
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;
;SCHON FUER AD-WANDLUNG ALSO TEMPO-EINSTELLUNG VORBEREITETER TEXT
;30-110ZPM
;162MS-48.6MS
;5.0625MS-1.51875MS  /32 NORMALE DURCHGANGSANZAHL FUER EINE EINHEIT ALSO DELAY
;
;TEILER 1:4(PRESCALER) UND OSZILLATOR(16MHZ) 1:4 ==>1:16
;
;16*0.25S=4S
;       340*4S=1.36MS*32=43.52MS ==> 111ZPM
;(1023+340)*4S=5.452MS*32=174.46MS ==> 28ZPM
;ALSO GRUNDWERT 340 ZUM NORMALEN AD-WERT ADDIEREN UND VON 0XFFFF ABZIEHEN
;
;-----------------------------------------------------------------------------
;----------------------------------------------------------------------------
;----------------------------------------------------------------------------

;*****************************************************************************
;*                              STRICH                                       *
;*****************************************************************************
STRICH          BTFSC   STRPKT, BIT6
                GOTO    III1
                BTFSC   STRPKT, BIT4
                GOTO    III1
                RETURN

III1        CALL    EIN
            CALL    DELAY
            CALL    DELAY
            CALL    DELAY
            CALL    AUS
            CALL    DELAY
            BCF     STRPKT, BIT7    ;STRICHMERKER AUS
            RETURN

;*****************************************************************************
;*                              PUNKT                                        *
;*****************************************************************************
PUNKT           BTFSC   STRPKT, BIT6
                GOTO    III2
                BTFSC   STRPKT, BIT4
                GOTO    III2
                RETURN

III2        CALL    EIN
            CALL    DELAY
            CALL    AUS
            CALL    DELAY
            BCF     STRPKT, BIT0    ;PUNKT MERKER AUS
            RETURN

;*****************************************************************************
;*                              X*10SEC ZEITSCHLEIFE                        *
;*****************************************************************************

ZSMUE       MOVWF   ZAE
MSA1        NOP             ;1X NOP=4TAKTE 
            NOP             
            NOP             
            NOP
            NOP
            
            NOP
            NOP
            NOP
            NOP
            NOP ;10STCK
            
            NOP
            NOP
            NOP
            NOP
            NOP ;15STCK
            
            NOP
            NOP
            NOP
            NOP
            NOP ;20STCK
            
            DECFSZ  ZAE, F
            GOTO    MSA1
            RETURN

;*****************************************************************************
;*                              CW-EIN                                       *
;*****************************************************************************
EIN
    BSF     PORTC, MORSE
    BSF     PORTC, MITHOERTON
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;   
    MOVF    MERK_SPEICHER_H, W
    SUBWF   SPEICHER_H, W       ;BEI GLEICH Z=1 0X0800=MERK_... UND SPEICHER_H
    BTFSS   STATUS, Z
    GOTO    EIN12
    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;BEI Z.B.: 0X0800    
    BTFSS   STRPKT, BIT5       ;1-BAKE
    GOTO    EIN04
    BCF     PORTC, LED_GN_CW   ;LEUCHTET GELB 
    BCF     PORTC, LED_RT_ENDE ;LEUCHTET GELB

;BAKE
    BTFSC   HELP_ROT, BIT0
    GOTO    EIN01X
    
    MOVF    SPEICHER_L, W       ;AUS ERSTES BYTE BEI FESTTEXT-SPEICHER
    SUBWF   F_SPEICHER_L, W
    BTFSS   STATUS, C
    RETURN
    
EIN01X    
    BSF     HELP_ROT, BIT0
    BSF     PORTC, LED_GN_CW   ;LEUCHTET NICHT
    BCF     PORTC, LED_RT_ENDE ;LEUCHTET NUR ROT 
    RETURN
    
EIN04    
    BTFSS   STRPKT, BIT6    ;1-NORMAL MORSEN // 0-FESTTEXT
    GOTO    EIN02
    
;NORMAL    
    BCF     PORTC, LED_GN_CW ;LEUCHTET
    RETURN
    
EIN02 ;FESTTEXT
    BTFSC   HELP_ROT, BIT0
    GOTO    EIN03X
    
    MOVF    SPEICHER_L, W       ;AUS ERSTES BYTE BEI FESTTEXT-SPEICHER
    SUBWF   F_SPEICHER_L, W
    BTFSS   STATUS, C
    GOTO    EIN03
    
EIN03X    
    BSF     HELP_ROT, BIT0
    BCF     PORTC, LED_RT_ENDE ;LEUCHTET
    RETURN    
    
EIN03
    BCF     PORTC, LED_GN_CW ;LEUCHTET
    RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;BEI BER 0X0900    
EIN12    
    BTFSS   STRPKT, BIT5       ;1-BAKE
    GOTO    EIN34
    BCF     PORTC, LED_GN_CW   ;LEUCHTET GELB 
    BCF     PORTC, LED_RT_ENDE ;LEUCHTET GELB

;BAKE
    MOVF    SPEICHER_H, W
    SUBWF   F_SPEICHER_H, W ;0X0900-0X800 Z=0 ;0X0900-0X0900 Z=1
    BTFSS   STATUS, Z
    RETURN
    
    BTFSC   HELP_ROT, BIT0
    GOTO    EIN31X
    
    MOVF    SPEICHER_L, W       ;AUS ERSTES BYTE BEI FESTTEXT-SPEICHER
    SUBWF   F_SPEICHER_L, W
    BTFSS   STATUS, C
    RETURN
    
EIN31X    
    BSF     HELP_ROT, BIT0
    BSF     PORTC, LED_GN_CW    ;LEUCHTET NICHT
    BCF     PORTC, LED_RT_ENDE  ;LEUCHTET NUR ROT 
    RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;    
EIN34    
    BTFSS   STRPKT, BIT6        ;1-NORMAL MORSEN // 0-FESTTEXT
    GOTO    EIN32
    
;NORMAL    
    BCF     PORTC, LED_GN_CW ;LEUCHTET
    RETURN
    
;FESTTEXT    
EIN32
    BTFSC   HELP_ROT, BIT0
    GOTO    EIN33X
    
    MOVF    SPEICHER_L, W       ;AUS ERSTES BYTE BEI FESTTEXT-SPEICHER
    SUBWF   F_SPEICHER_L, W
    BTFSS   STATUS, C
    GOTO    EIN33
     
    MOVF    SPEICHER_H, W
    SUBWF   F_SPEICHER_H, W ;0X0800-0X900 Z=0 ;0X0900-0X0900 Z=1
    BTFSS   STATUS, Z
    GOTO    EIN33   
    
EIN33X    
    BSF     HELP_ROT, BIT0
    BCF     PORTC, LED_RT_ENDE ;LEUCHTET
    RETURN    
    
EIN33
    BCF     PORTC, LED_GN_CW ;LEUCHTET
    RETURN
    
;*****************************************************************************
;*                              CW-AUS                                       *
;*****************************************************************************
AUS
    BCF     PORTC, MORSE
    BCF     PORTC, MITHOERTON
    
    ;BTFSS   STRPKT, BIT5       ;1-BAKE
    ;GOTO    AUS04
    BSF     PORTC, LED_GN_CW   ;LEUCHTET NICHT
    BSF     PORTC, LED_RT_ENDE ;LEUCHTET NICHT

    
;AUS04    
;    BTFSS   STRPKT, BIT6      ;1-NORMAL MORSEN // 0-FESTTEXT
;    GOTO    AUS02
    
;    BSF     PORTC, LED_GN_CW  ;LEUCHTET NICHT
;    RETURN
    
;AUS02 ;FESTTEXT
;    MOVF    SPEICHER_L, W       ;AUS ERSTES BYTE BEI FESTTEXT-SPEICHER
;    SUBWF   F_SPEICHER_L, W
;    BTFSS   STATUS, C
;    GOTO    AUS03
    
;    BSF     PORTC, LED_RT_ENDE ;LEUCHTET NICHT
;    RETURN    
    
;AUS03
;    BSF     PORTC, LED_GN_CW ;LEUCHTET NICHT
    RETURN

;*****************************************************************************
;*                              X-20MSEC ZEITSCHLEIFE                        *
;*****************************************************************************
ZS20MSEC                MOVWF   MERK1

T031                    MOVLW   D'2'                     
                        MOVWF   MERK                     

T011                    MOVLW   D'178'
                        MOVWF   TMR0                     
                        BCF     INTCON, TMR0IF             
                
T021                    BTFSS   INTCON, TMR0IF             
                        GOTO    T021                     
                        
                        DECFSZ  MERK, F                  
                        GOTO    T011                     

                        DECFSZ  MERK1, F                 
                        GOTO    T031                     

                        RETURN

;ZEITBERECHNUNG FUER 10MS
;PRESCALER 256X  *  SYSTEM 4X  * TAKTZEIT ====> 256*4*0.125SEC (4MHZ)=128S   
;10MS : 128S= 78                                                   
;ALSO
;128S*D'78'=10MS
;TMR0 ALSO D'256'-D'78'=D'178' ENTSPRICHT CA. 10MS
;178 DEZIMAL OBEN EINTRAGEN
;*****************************************************************************
;*                              X-10MSEC ZEITSCHLEIFE UND ABFRAGE            *
;*****************************************************************************                  
ZS10MSEC_SCHALTER_TASTER
                        MOVWF   MERK
                        
TT01                    MOVLW   D'178'              ;SIEHE OBEN BEI 20MSEC / HIER 10MSEC
                        MOVWF   TMR0                     
                        BCF     INTCON, TMR0IF             
                
TT00                    BTFSC   INTCON, TMR0IF
                        GOTO    TT02
;---------------------------------------------------- 
                        BTFSC   PORTC, PROGRAMMIEREN    ;BEI HIGH SCHALTER ES WIRD PROGRAMMIERT
                        GOTO    TT10
                        RETURN
;----------------------------------------------------           
TT10                    BTFSC   PORTB, FESTTEXT0
                        GOTO    TT11
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
TT11                    BTFSC   PORTB, FESTTEXT1
                        GOTO    TT12
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
TT12                    BTFSC   PORTB, FESTTEXT2
                        GOTO    TT13
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
TT13                    BTFSC   PORTB, FESTTEXT3
                        GOTO    TT14
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
TT14                    BTFSC   PORTB, FESTTEXT4
                        GOTO    TT15
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
TT15                    BTFSC   PORTB, FESTTEXT5
                        GOTO    TT00
                        BSF     ABFRAGE, BIT0
                        RETURN
;----------------------------------------------------
                        
TT02                    DECFSZ  MERK, F                  
                        GOTO    TT01                            

                        RETURN
                        

;*****************************************************************************
;*                              BEENDEN  TASTER SCHALTER                     *
;*****************************************************************************                  
BEENDEN                 ;BTFSC   PORTC, PROGRAMMIEREN    ;BEI HIGH SCHALTER ES WIRD PROGRAMMIERT
                        ;GOTO    T10
                        ;BSF     ABFRAGE, BIT0
                        ;RETURN
;----------------------------------------------------           
;T10
                        BTFSC   PORTB, FESTTEXT0
                        GOTO    T11
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
T11                     BTFSC   PORTB, FESTTEXT1
                        GOTO    T12
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
T12                     BTFSC   PORTB, FESTTEXT2
                        GOTO    T13
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
T13                     BTFSC   PORTB, FESTTEXT3
                        GOTO    T14
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
T14                     BTFSC   PORTB, FESTTEXT4
                        GOTO    T15
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
T15                     BTFSC   PORTB, FESTTEXT5
                        RETURN
                        BSF     ABFRAGE, BIT0
                        RETURN
                        
;*****************************************************************************
;*                              WRITE                                        *
;*****************************************************************************
;DIE ADRESSE MUSS STEHEN
;DAS ZU SPEICHERNDE BYTE IN W STEHEN

F_WRITE
        BANK2
        MOVWF   EEDATA
        BANK0
        MOVLW   0X00 ;HIGH DATEN IMMER 0X00 AB ADRESSE 0X0802
        ;MOVF   DAT_H, W
        BANK2
        MOVWF   EEDATH
        BANK0
        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        
        MOVLW   0XFA            ;SPEICHERBERLAUF AB 0XFA
        SUBWF   F_SPEICHER_L, W
        BTFSS   STATUS, Z
        GOTO    W_2
        
        DECFSZ  UEBERLAUF, F    ;IST 2 // RUNTERZAEHLEN
        GOTO    W_2
        BSF     STRPKT, BIT2    ;MERKER AUF EIN
        RETURN
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

W_2     MOVF    F_SPEICHER_L, W         ; 0X802 BEGINN //UEBERLAUF WEITER 0X900 
        SUBLW   0X00
        BTFSS   STATUS, Z
        GOTO    W_4
        INCF    F_SPEICHER_H, F
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        
W_4     MOVF    F_SPEICHER_L, W         ;ADRESSE LOW+HIGH EINTRAGEN
        BANK2
        MOVWF   EEADR
        BANK0
        MOVF    F_SPEICHER_H, W
        BANK2
        MOVWF   EEADRH

        BANK3
        BSF     EECON1, EEPGD           ;PROGRAMM MEMORY AUSWAEHLEN
        BSF     EECON1, WREN            ;ALLOWS WRITE CYCLUS
        MOVLW   0X55
        MOVWF   EECON2  
        MOVLW   0XAA
        MOVWF   EECON2  
        BSF     EECON1, WR              ;SCHREIBEN VON DAT_L/DAT_H AUF ADRESSE ADR_L/ADR_H
        NOP
        NOP
        BCF     EECON1, WREN            ;KEIN SCHREIBZYKLUS MEHR
        BANK0
                
                RETURN

;*****************************************************************************
;*                              WRITE                                        *
;*****************************************************************************
;HIER!!! AB WANN ROT LEUCHTEN AUF ADRESSE Z.B.:0X0801
;NUR EINE SPEICHERZELLE         
F_WRITE_1
        MOVF    SPEICHER_L, W    ;VORHER BERECHNET //NICHT UNTER 0X00         
        BANK2
        MOVWF   EEDATA           ;LOW DATEN WAR IN W
        BANK0
        MOVF    SPEICHER_H, W    ;HIGH DATEN
        BANK2
        MOVWF   EEDATH
                                 ;Z.B.:0X802 BEGINN //UEBERLAUF WEITER 0X900
        MOVLW   0X01             ;ACHTUNG AUF ADRESSE=0X801 AB WANN ROT LEUCHTEN 
        BANK2
        MOVWF   EEADR
        BANK0
        MOVF    MERK_SPEICHER_H, W
        BANK2
        MOVWF   EEADRH

        BANK3
        BSF     EECON1, EEPGD           ;PROGRAMM MEMORY AUSWAEHLEN
        BSF     EECON1, WREN            ;ALLOWS WRITE CYCLUS
        MOVLW   0X55
        MOVWF   EECON2  
        MOVLW   0XAA
        MOVWF   EECON2  
        BSF     EECON1, WR              ;SCHREIBEN VON DAT_L/DAT_H AUF ADRESSE ADR_L/ADR_H
        NOP
        NOP
        BCF     EECON1, WREN            ;KEIN SCHREIBZYKLUS MEHR
        BANK0

                RETURN

;*****************************************************************************
;*                               READ                                        *
;*****************************************************************************
;DAS ERGEBNIS DES WERTES VOM STEHT AM ENDE IN W

F_READ  MOVF    F_SPEICHER_L, W         ; 0X802 BEGINN //UEBERLAUF WEITER 0X900 
        SUBLW   0X00
        BTFSS   STATUS, Z
        GOTO   R0
        INCF   F_SPEICHER_H, F

R0      MOVF    F_SPEICHER_L, W         ;ADRESSE LOW+HIGH EINTRAGEN
        BANK2
        MOVWF   EEADR
        BANK0
        MOVF    F_SPEICHER_H, W
        BANK2
        MOVWF   EEADRH

        BANK3
        BSF     EECON1, EEPGD           ;PROGRAMM MEMORY AUSWAEHLEN
        BSF     EECON1, RD              ;LESEN MIT OBIGER ADRESSE ADR_L/ADR_H
        NOP
        NOP
        BANK2
        MOVF   EEDATH, W
        BANK0
        ; FUER ROT LEUCHTEN ENDE MIT F_SPEICHER_L AUSLESEN BEI ADRESSE Z.B: 0X801
        MOVWF  HELP_SPEICHER_H
        BANK2
        MOVF    EEDATA, W               ;AUS SPEICHER DATEN LESEN
        BANK0
        ; FUER ROT LEUCHTEN ENDE MIT F_SPEICHER_L AUSLESEN BEI ADRESSE Z.B: 0X801
        ;MOVWF  SPEICHER_L              ,IM PROGRAMM
        
        RETURN
                
                


    
    
    
    END
