;****************************************************************************************
;*                           DCF77-FUNKSCHALT-UHR MIT ANZEIGE VON DL3UKH                *
;*                           ===========================================                *
;*                                                                                      *
;****************************************************************************************

    LIST    P=16F628A    
    TITLE   "DCF-77 FUNKUHR"

    INCLUDE <P16F628A.INC>

    ERRORLEVEL -302

;ALS PIC-IC WURDE GENOMMEN PIC16F628A

;DER QUARZ HAT 16,0000 MHZ ALSO T=0.0625S  T==TAKTZEIT 

__CONFIG   _HS_OSC & _WDT_OFF & _PWRTE_OFF & _BODEN_OFF & _MCLRE_OFF & _LVP_OFF & _DATA_CP_OFF & _CP_OFF


;REGISTER (MAX. 80 STCK) ZUORDNEN NACHFOLGEND DER FESTEN REGISTERN

W_STACK EQU 0X22    ;FR PUSH+POP
S_STACK EQU 0X23    ;FR PUSH+POP
HELP0   EQU 0X24    ;500MS-ZHLER //BEI 15SEC-PAUSE UND 1SEC-QUARZ-TAKT
MERK    EQU 0X25    ;BIT6=BEI MIN/H NICHTBEREINSTIMMUNG DOCH ZULASSUNG
                    ;     BEI 1.-TEM START
                    ;BIT7=MERKER BEI DCF-ZEITBERNAHME KURZ BLINKEN
                    ;     VON 00SEC NACH 01SEC
                    ;BIT0=ZEITUMSTELLUNGBIT DER 16-SEC
                    ;BIT1=MERKER FR ZEITUMSTELLUNG

Z_LL    EQU 0X26        ;ZHLER-LOW-(LOW=BYTE)
Z_LH    EQU 0X27        ;ZHLER-LOW-(HIGH=BYTE)
Z_H     EQU 0X28        ;ZHLER-HIGH-(ZEIT)
Z_IMP   EQU 0X29        ;ZHLER SEC-IMPULSE
DCF_DA  EQU 0X2A        ;BIT0 ==> 1=DCF IST DA, 0=DCF IST NICHT DA

OK      EQU 0X2B        ;BIT0=MIN-PARITT BIT1=H-PARITT BIT2=RAHMEN><
PAR     EQU 0X2C        ;PARITT IM AUSLESEPROZESS
ZUST    EQU 0X2D        ;ZUSTAND =1


SEC     EQU 0X2E        ;ANZEIGE-ZEIT UND QARZ-ZEIT
MIN     EQU 0X2F 
H       EQU 0X30 

I_MIN   EQU 0X31        ;IMPULS AUSGELESENE ZEIT
I_H     EQU 0X32 

MIN_V   EQU 0X33        ;ZUR +1 VERGLEICHSBERECHNUNG
H_V     EQU 0X34 

MIN_1   EQU 0X35        ;ANFANGSVERGLEICH ODER BEI ZEITUMSTELLUNG
H_1     EQU 0X36        ;ZWEI ZEITEN MESSEN ZUR SICHERHEIT

;==================================================
HELP1   EQU 0X37       ;HILFSZELLE
HELP2   EQU 0X38       ;HILFSZELLE
HELP3   EQU 0X39       ;HILFSZELLE
X4      EQU 0X3A       ;MS1 * 4 WEGEN QUARZ

BIT     EQU 0X3B       ;LCD HILFSZELLE
MERKE   EQU 0X3C       ;LCD HILFSZELLE
;==================================================
;FR SCHALTEN

MERA    EQU 0X3D       ;HILFSZELLE
MERB    EQU 0X3E       ;HILFSZELLE
MERC    EQU 0X3F       ;HILFSZELLE
ZAE     EQU 0X40       ;HILFSZELLE

;--------------------------------------------

;VARIABLEN
BIT7    EQU 7       ; BIT 7
BIT6    EQU 6       ; BIT 6
BIT5    EQU 5       ; BIT 5
BIT4    EQU 4       ; BIT 4
BIT3    EQU 3       ; BIT 3 
BIT2    EQU 2       ; BIT 2
BIT1    EQU 1       ; BIT 1 
BIT0    EQU 0       ; BIT 0

SCHALT  EQU 1       ;PORTA BIT1

;==================================================
RS      EQU 2       ; PORTA BIT2 UMSCHALTEN BEFEHL/DATEN      BEI WRITE DATEN IST ES HIGH
EN      EQU 3       ; PORTA BIT3 ENABLE FALLENDE FLANKE
;==================================================

;------------ MACROS ---------------------------------------------------------

PUSH    MACRO
        MOVWF   W_STACK
        MOVF    STATUS, W
        MOVWF   S_STACK
        ENDM
;----------------------------------------------------------------------------

POP     MACRO
        MOVF    S_STACK, W
        MOVWF   STATUS
        SWAPF   W_STACK, F
        SWAPF   W_STACK, W
        ENDM
;----------------------------------------------------------------------------

MS1     MACRO               ; FR EINE MILLISEKUNDE
        BCF INTCON, T0IF    ;TIMER0 KEIN INTERRUPT + OVERFLOW = 0
        BCF INTCON, T0IE    ;KEIN INTERRUPT
        MOVLW   0X06        ;1MS/16=6.25MYS/0.25MYS=250TAKTE
        MOVWF   TMR0        ;0X100(256)-0XFA(250)=0X06(6)  +OHNE(JUSTAGE)
        BSF STATUS, RP0     ;BANK1
        MOVLW   B'00000001' ;PRESCALE1:4 / SYSTEMCLOCK T/4 ==>1/16
        MOVWF   OPTION_REG  ;TEILER 1:4 + CYCLUS CLOCK
        BCF STATUS, RP0     ;BANK0
        ENDM
;----------------------------------------------------------------------------



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;ZEITEN GENDERT
; ACHTUNG HIER KOMMEN DIE IMPULS-BEREICHE REIN
; IN DIESEN BEREICHEN WERDEN DIE LNGEN ZU LOW UND HIGH

AUSW    MACRO
        MOVLW   D'60'       
        SUBWF   Z_H, W
        BTFSS   STATUS, C   ;GRER ALS 60MS SONST FEHLERPUNKT
        GOTO    VOR1
        MOVLW   D'140'      ;AUCH SCHREIBBAR ALS H'8C'
        SUBWF   Z_H, W
        BTFSC   STATUS, C   ;KLEINER ALS 140MS SONST FEHLERPUNKT
        GOTO    SU
        MOVLW   D'0'
        MOVWF   Z_H
        GOTO    RECHN

SU      MOVLW   D'240'      ;AUCH SCHREIBBAR ALS H'F0'
        SUBWF   Z_H, W
        BTFSC   STATUS, C   ;KLEINER ALS 240MS SONST FEHLERPUNKT
        GOTO    VOR1
        MOVLW   D'160'      
        SUBWF   Z_H, W
        BTFSS   STATUS, C   ;GRER ALS 160MS SONST FEHLERPUNKT
        GOTO    VOR1
        MOVLW   D'1'
        MOVWF   Z_H
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

RECHN   MOVLW   D'37'       ;BEI >= 37 ANS ENDE
        SUBWF   Z_IMP, W
        BTFSC   STATUS, C
        GOTO    D_ENDE

        MOVLW   D'16'       ;BEI <= 16 ANS ENDE
        SUBWF   Z_IMP, W
        BTFSS   STATUS, C
        GOTO    D_ENDE


;------------ JETZT GEHTS LOS ---------------------------------------

        MOVLW   D'16'       ;ZEITUMSTELLUNG
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    MI00
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    MI01
        BSF     MERK, BIT0
        GOTO    D_ENDE

MI01    BCF     MERK, BIT0
        GOTO    D_ENDE


MI00    MOVLW   D'21'       ;1MIN
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    I11
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_MIN, BIT0
        BTFSS   PAR, BIT0   ;PARITT
        GOTO    PA0
        BCF     PAR, BIT0
        GOTO    D_ENDE

PA0     BSF     PAR, BIT0
        GOTO    D_ENDE

I11     MOVLW   D'22'       ;2MIN
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    I12
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_MIN, BIT1
        BTFSS   PAR, BIT0   ;PARITT
        GOTO    PA1
        BCF     PAR, BIT0
        GOTO    D_ENDE

PA1     BSF     PAR, BIT0
        GOTO    D_ENDE


I12     MOVLW   D'23'       ;4MIN
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    I13
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_MIN, BIT2
        BTFSS   PAR, BIT0   ;PARITT
        GOTO    PA2
        BCF     PAR, BIT0
        GOTO    D_ENDE

PA2     BSF     PAR, BIT0
        GOTO    D_ENDE

I13     MOVLW   D'24'       ;8MIN
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    I14
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_MIN, BIT3
        BTFSS   PAR, BIT0   ;PARITT
        GOTO    PA3
        BCF     PAR, BIT0
        GOTO    D_ENDE

PA3     BSF PAR, BIT0
        GOTO    D_ENDE


I14     MOVLW   D'25'       ;10MIN
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    I15
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_MIN, BIT4
        BTFSS   PAR, BIT0   ;PARITT
        GOTO    PA4
        BCF     PAR, BIT0
        GOTO    D_ENDE

PA4     BSF     PAR, BIT0
        GOTO    D_ENDE


I15     MOVLW   D'26'       ;20MIN
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    I16
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_MIN, BIT5
        BTFSS   PAR, BIT0   ;PARITT
        GOTO    PA5
        BCF     PAR, BIT0
        GOTO    D_ENDE

PA5     BSF     PAR, BIT0
        GOTO    D_ENDE


I16     MOVLW   D'27'       ;40MIN
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    I17
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_MIN, BIT6
        BTFSS   PAR, BIT0   ;PARITT
        GOTO    PA6
        BCF     PAR, BIT0
        GOTO    D_ENDE

PA6     BSF     PAR, BIT0
        GOTO    D_ENDE


I17     MOVLW   D'28'       ;PARITT
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    II1
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z   ;
        GOTO    IP1
        BTFSS   PAR, BIT0   ;
        GOTO    IP2
        BSF     OK, BIT0
        GOTO    D_ENDE

IP2     BCF     OK, BIT0
        GOTO    VOR

IP1     BTFSC   PAR, BIT0
        GOTO    IP3
        BSF     OK, BIT0
        GOTO    D_ENDE

IP3     BCF OK, BIT0
        GOTO    VOR

II1     MOVLW   D'29'       ;1H
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    II2
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_H, BIT0
        BTFSS   PAR, BIT1   ;PARITT
        GOTO    PA7
        BCF     PAR, BIT1
        GOTO    D_ENDE

PA7     BSF     PAR, BIT1
        GOTO    D_ENDE

II2     MOVLW   D'30'       ;2H
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    II3
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_H, BIT1
        BTFSS   PAR, BIT1   ;PARITT
        GOTO    PA9
        BCF     PAR, BIT1
        GOTO    D_ENDE

PA9     BSF     PAR, BIT1
        GOTO    D_ENDE

II3     MOVLW   D'31'       ;4H
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    II4
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_H, BIT2
        BTFSS   PAR, BIT1   ;PARITT
        GOTO    PA10
        BCF     PAR, BIT1
        GOTO    D_ENDE

PA10    BSF     PAR, BIT1
        GOTO    D_ENDE


II4     MOVLW   D'32'       ;8H
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    II5
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_H, BIT3
        BTFSS   PAR, BIT1   ;PARITT
        GOTO    PA11
        BCF     PAR, BIT1
        GOTO    D_ENDE

PA11    BSF     PAR, BIT1
        GOTO    D_ENDE

II5     MOVLW   D'33'       ;10H
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    II6
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_H, BIT4
        BTFSS   PAR, BIT1   ;PARITT
        GOTO    PA12
        BCF     PAR, BIT1
        GOTO    D_ENDE

PA12    BSF     PAR, BIT1
        GOTO    D_ENDE

II6     MOVLW   D'34'       ;20H
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    II7
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE
        BSF     I_H, BIT5
        BTFSS   PAR, BIT1   ;PARITT
        GOTO    PA13
        BCF     PAR, BIT1
        GOTO    D_ENDE

PA13    BSF     PAR, BIT1
        GOTO    D_ENDE


II7     MOVLW   D'35'       ;PARITT
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    A_ENDE
        MOVLW   D'1'
        SUBWF   Z_H, W
        BTFSS   STATUS, Z
        GOTO    XIP1
        BTFSS   PAR, BIT1
        GOTO    XIP2
        BSF     OK, BIT1
        GOTO    D_ENDE

XIP2    BCF     OK, BIT1
        GOTO    VOR

XIP1    BTFSC   PAR, BIT1
        GOTO    XIP3
        BSF     OK, BIT1
        GOTO    D_ENDE

XIP3    BCF     OK, BIT1
        GOTO    VOR

A_ENDE  MOVLW   D'36'       ;AUSWERTEN
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    D_ENDE

;AUSWERTEN
        MOVLW   0X07        ;KNNTE MAN WEGLASSEN
        SUBWF   OK, W
        BTFSS   STATUS, Z
        GOTO    VOR

;-------------- ANZEIGE JA ODER NEIN ------------------------------------------

        INCF    ZUST, F
    
        MOVLW   D'1'
        SUBWF   ZUST, W
        BTFSS   STATUS, Z
        GOTO    GO1

;-------------- MERKER FR ZEITUMSTELLUNG BEI UNGELEICHHEIT -------------------
    
        MOVLW   0X45
        SUBWF   MIN, W
        BTFSC   STATUS, C   ;KLEINER GLEICH DER 45-TEN MIN SPRUNG
        GOTO    STA1        ;HIER GRER DER 45-TEN MIN
    
        MOVLW   0X30
        SUBWF   MIN, W
        BTFSS   STATUS, C   ;GRER 30MIN SPRUNG
        GOTO    STA
    
        BTFSS   MERK, BIT0  ;ALSO JETZT ZWISCHEN DER 30. BIS 45.-TEN MIN
        GOTO    STA3
        BSF     MERK, BIT1
        GOTO    STA

STA3    BCF     MERK, BIT1
        GOTO    STA

STA1    BTFSS   MERK, BIT1
        GOTO    STA2
        BTFSS   MERK, BIT0
        GOTO    STA2
        GOTO    STA

STA2    BCF MERK, BIT1

                       ;VON 30-45MIN WIRD BIT1 HIGH GESETZT
                       ;UND VON 45-59MIN MU BIT1 + BIT0 HIGH SEIN
                       ;-AB 00-30MIN BLEIBT BIT1 GESETZT BIS UNGLEICHHEIT AUFTRITT
                       ; UND WIRD DANN SOFORT ANGEZEIGT

;-------------- MIN+H VERGLEICH ----------------------------------------------

STA     MOVF    MIN, W
        MOVWF   MIN_V
        MOVF    H, W
        MOVWF   H_V

LLOP1   BCF     INTCON, GIE     ;INTERRUPT SPERREN, DA BANK1 VORKOMMT
        BTFSC   INTCON, GIE
        GOTO    LLOP1
        CALL    PLUS1
        BSF     INTCON, GIE     ;INTERRUPT WIEDER ZULASSEN
    
        MOVF    I_MIN, W
        SUBWF   MIN_V, W
        BTFSS   STATUS, Z
        GOTO    GO_F_1
        MOVF    I_H, W
        SUBWF   H_V, W
        BTFSS   STATUS, Z
        GOTO    GO_F_1
    
        MOVLW   D'100'          ;ALLES OK KANN MAN IN DER MIN-LUECKE ANZEIGEN
        MOVWF   ZUST
        GOTO    D_ENDE

GO1     MOVLW   D'2'
        SUBWF   ZUST, W
        BTFSS   STATUS, Z
        GOTO    GO3
    
        MOVF    MIN_1, W
        MOVWF   MIN_V
        MOVF    H_1, W
        MOVWF   H_V

LLOP2   BCF     INTCON, GIE     ;INTERRUPT SPERREN, DA BANK1 VORKOMMT
        BTFSC   INTCON, GIE
        GOTO    LLOP2
        CALL    PLUS1
        BSF     INTCON, GIE     ;INTERRUPT WIEDER ZULASSEN
    
        MOVF    I_MIN, W
        SUBWF   MIN_V, W
        BTFSS   STATUS, Z
        GOTO    GO_F_2
        MOVF    I_H, W
        SUBWF   H_V, W
        BTFSS   STATUS, Z
        GOTO    GO_F_2

ZUR     MOVLW   D'100'          ;ALLES OK KANN MAN IN DER MIN-LUECKE ANZEIGEN
        MOVWF   ZUST
        GOTO    D_ENDE

GO_F_1  BTFSS   MERK, BIT1      ;MERKER FR UNGLEICHHEIT ==> ZEITUMSTELLUNG
        GOTO    GOF1
        BCF     MERK, BIT0
        BCF     MERK, BIT1
        GOTO    ZUR

GOF1    MOVF    I_MIN, W
        MOVWF   MIN_1
        MOVF    I_H, W
        MOVWF   H_1
        GOTO    D_ENDE

GO_F_2  MOVF    I_MIN, W
        MOVWF   MIN_1
        MOVF    I_H, W
        MOVWF   H_1
    
        MOVLW   D'1'
        MOVWF   ZUST
        GOTO    D_ENDE

GO3     MOVLW   D'0'
        MOVWF   ZUST
        GOTO    D_ENDE

;-----------------------------------------------------------------------------

VOR1    BCF OK, BIT2    ;FEHLER MERKEN RAHMEN < >
VOR ;BSF PORTB, FEHLER   ;PARITT STIMMT NICHT PUNKT WIRD SOFORT
                ;ANGEZEIGT UND GEMERKT

        MOVLW   H'85'                  
        CALL    BEFEHL
        MOVLW   H'2C'
        CALL    DATEN


D_ENDE  NOP
        ENDM

;------------------------- ENDE MACROS -----------------------------------------------


    ORG 0X0000
    GOTO MAIN           ; SPRUNG ZUM HAUPTPROGRAMM
    ORG 0X0004
    GOTO INTERR         ; SPRUNG ZUM INTERRUPTPROGRAMM

    ORG 0X0010
;*****************************************************************************
;*                              INTERRUPTPROGRAMM                            *
;*                              22.09.02                                     *
;*****************************************************************************

INTERR  PUSH
        BCF T1CON, TMR1ON               ;STOP TIMER1        ;4T + 8TINTERRUPT? JUSTAGE
        BCF PIR1, TMR1IF                ;OVERFLOW 0 MACHEN  ;4T
        BSF INTCON, PEIE                ;ZUR SICHERHEIT PERIPH. INTERRUPT ZULASSEN
        MOVLW   0XD0                    ;4T
        MOVWF   TMR1L                   ;4T
        MOVLW   0X0B                    ;4T
        MOVWF   TMR1H                   ;4T

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;JUSTAGE GENDERT
        
        NOP                             ;4T ZUR JUSTAGE
        NOP                             ;4T
        NOP                             ;4T
        NOP                             ;4T
    
        NOP                             ;4T
        NOP                             ;4T
    
        
        NOP
        NOP
        NOP
        NOP
        NOP

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
        
        MOVLW   0X31        ;+STEUERBITS FR DIESEN TIMER   ;4T
        MOVWF   T1CON       ;START TIMER1       ;4T GESAMT=14*4T + 1*8T=64T

QKJ     DECF    HELP0, F    ;SEKUNDEN-ERKENNUNG // SPRUNG BEI DEM ENTSPRECHEND ???? KOENNTE FEHLER SEIN

        MOVF    HELP0, W
        SUBLW   D'1'
        BTFSC   STATUS, Z
        GOTO    ZAEL

        MOVF    HELP0, W
        SUBLW   D'2'
        BTFSC   STATUS, Z
        GOTO    QEN

        MOVF    HELP0, W
        SUBLW   D'3'
        BTFSC   STATUS, Z
        GOTO    QEN

        MOVF    HELP0, W
        SUBLW   D'4'
        BTFSC   STATUS, Z
        GOTO    QEN

        MOVF    HELP0, W
        SUBLW   D'5'
        BTFSC   STATUS, Z
        GOTO    NO_SEC

        MOVF    HELP0, W
        SUBLW   D'6'
        BTFSC   STATUS, Z
        GOTO    QEN

        MOVF    HELP0, W
        SUBLW   D'7'
        BTFSC   STATUS, Z
        GOTO    QEN

        MOVF    HELP0, W         
        SUBLW   D'8'
        BTFSC   STATUS, Z
        GOTO    QEN

; BEI 1 ZEIT ZHLEN, SIEHE GLEICH UNTERHALB


;----------- SEKUNDEN, MINUTEN UND STUNDEN ZHLUNG DER NORMALEN QUARZ-ZEIT ---

ZAEL    MOVF    SEC, W
        ANDLW   0X0F
        ADDLW   0X01
        SUBLW   0X0A
        BTFSS   STATUS, Z
        GOTO    PPP0

        MOVF    SEC, W
        ANDLW   0XF0
        ADDLW   0X10
        GOTO    PPP1

PPP0    MOVF    SEC, W
        ADDLW   0X01

PPP1    MOVWF   SEC
        SUBLW   0X60
        BTFSS   STATUS, Z
        GOTO    MMA

        CLRF    SEC         ;
        MOVF    MIN, W
        ANDLW   0X0F
        ADDLW   0X01
        SUBLW   0X0A
        BTFSS   STATUS, Z
        GOTO    PPP2

        MOVF    MIN, W
        ANDLW   0XF0
        ADDLW   0X10
        GOTO    PPP3

PPP2    MOVF    MIN, W
        ADDLW   0X01

PPP3    MOVWF   MIN
        SUBLW   0X60
        BTFSS   STATUS, Z
        GOTO    MMA

        CLRF    MIN
        MOVF    H, W
        ANDLW   0X0F
        ADDLW   0X01
        SUBLW   0X0A
        BTFSS   STATUS, Z
        GOTO    PPP4

        MOVF    H, W
        ANDLW   0XF0
        ADDLW   0X10
        GOTO    PPP5

PPP4    MOVF    H, W
        ADDLW   0X01

PPP5    MOVWF   H
        SUBLW   0X24
        BTFSS   STATUS, Z
        GOTO    MMA
        CLRF    H

MMA     NOP


;==========================================================
;SEC-DARSTELLEN
            MOVF    SEC, W                  
            MOVWF   HELP2

            MOVLW   H'87'                  
            CALL    BEFEHL
            
            MOVF    HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

            MOVLW   H'86'                  
            CALL    BEFEHL

            SWAPF   HELP2, W

            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

;MIN
            MOVF    MIN, W                  
            MOVWF   HELP2

            MOVLW   H'84'                  
            CALL    BEFEHL
            
            MOVF    HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

            MOVLW   H'83'                  
            CALL    BEFEHL

            SWAPF   HELP2, W

            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

;H
            MOVF    H, W                  
            MOVWF   HELP2

            MOVLW   H'81'                  
            CALL    BEFEHL
            
            MOVF    HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

            MOVLW   H'80'                  
            CALL    BEFEHL

            SWAPF   HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'

            SUBLW   H'30'
            BTFSC   STATUS, Z
            GOTO    CCBN

            SWAPF   HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'
            GOTO    CCCBN

CCBN        MOVLW   H'20'
CCCBN       CALL    DATEN


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;NEU-PIC16F628
;DIE ABFRAGE DER SCHALTZEIT KOMMT HIER REIN

SSS101  BTFSC   MERB, BIT0      ;ZULASSUNG FUER DAS SCHALTEN, DIE DCF77-ZEIT WURDE ERKANNT BZW. DIE UHR GESTELLT BEI HIGH
        GOTO    KMML

        BTFSC   MERB, BIT7      ;BEI AUS-ZUSTAND WIRD EINSCHALT-TABELLE ABGEFRAGT ....
        GOTO    AUS1

;VERGLEICHEN BEI EINSCHALTEN
        CLRF    ZAE             ;ZAEHLER BEGINNT BEI NULL
SPUCA   CALL    SEC_EIN
        MOVWF   MERA
        MOVLW   H'00'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVLW   0XFF                ;ENDEERKENNUNG DER TABELLE
        SUBWF   MERA, W         ;DAS ENDEBYTE MUSS AM ENDE DER TABELLE FF HEX SEIN
        BTFSC   STATUS, Z
        GOTO    KMML

        MOVF    MERA, W
        SUBWF   SEC, W
        BTFSS   STATUS, Z
        GOTO    SPUC22

        CALL    MIN_EIN
        MOVWF   MERA
        MOVLW   H'00'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVF    MERA, W
        SUBWF   MIN, W
        BTFSS   STATUS, Z
        GOTO    SPUC22

        CALL    H_EIN
        MOVWF   MERA
        MOVLW   H'00'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVF    MERA, W
        SUBWF   H, W
        BTFSS   STATUS, Z
        GOTO    SPUC22
        
        BSF     PORTA, SCHALT       ;EINSCHALTEN DA SEC, MIN + H AUS TABELLE BEREINSTIMMT
        BSF     MERB, BIT7
        GOTO    KMML

SPUC22  INCF    ZAE, F              ;ZAEHLER UM 1 ERHHEN
        GOTO    SPUCA



;VERGLEICHEN BEI AUSSCHALTEN
AUS1    CLRF    ZAE             ;ZAEHLER BEGINNT BEI NULL
SPUKA   CALL    SEC_AUS
        MOVWF   MERA
        MOVLW   H'00'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVLW   0XFF                ;ENDEERKENNUNG DER TABELLE
        SUBWF   MERA, W         ;DAS ENDEBYTE MUSS AM ENDE DER TABELLE FF HEX SEIN
        BTFSC   STATUS, Z
        GOTO    KMML

        MOVF    MERA, W
        SUBWF   SEC, W
        BTFSS   STATUS, Z
        GOTO    SPUK22

        CALL    MIN_AUS
        MOVWF   MERA
        MOVLW   H'00'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVF    MERA, W
        SUBWF   MIN, W
        BTFSS   STATUS, Z
        GOTO    SPUK22

        CALL    H_AUS
        MOVWF   MERA
        MOVLW   H'00'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVF    MERA, W
        SUBWF   H, W
        BTFSS   STATUS, Z
        GOTO    SPUK22
        
        BCF     PORTA, SCHALT       ;AUSSCHALTEN DA SEC, MIN + H AUS TABELLE BEREINSTIMMT
        BCF     MERB, BIT7
        GOTO    KMML

SPUK22  INCF    ZAE, F              ;ZAEHLER UM 1 ERHHEN
        GOTO    SPUKA


;-------------------------------------------------------------
;ENDE DER ABFRAGE FR NEU-PIC16F628

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

KMML        MOVLW   D'9'
            MOVWF   HELP0

;DOPPELPUNKT WIRD ANGEZEIGT
            MOVLW   H'82'                  
            CALL    BEFEHL
            MOVLW   H'3A'
            CALL    DATEN

            GOTO    EEE

NO_SEC      BTFSS   DCF_DA, BIT0    ;BEI DCF_DA=1 BLINKT ES
            GOTO    EEE

;DOPPELPUNKT WIRD AUSGESCHALTET
            MOVLW   H'82'                  
            CALL    BEFEHL
            MOVLW   H'20'
            CALL    DATEN


EEE         BTFSS   MERK, BIT7      ;KURZZEITIG BEI 00SEC BLINKEN,
            GOTO    QEN             ;WENN DIE DCF-ZEIT BERNOMMEN
            MOVLW   0X00            ;NUR EINE HALBE SEC BLINKEN
            SUBWF   SEC, W
            BTFSS   STATUS, Z
            GOTO    QEE

;FEHLER KOMMA
            MOVLW   H'85'                  
            CALL    BEFEHL
            MOVLW   H'2C'
            CALL    DATEN
            GOTO    QEN

QEE         BCF MERK, BIT7

;FEHLER PUNKT
            MOVLW   H'85'                  
            CALL    BEFEHL
            MOVLW   H'2E'
            CALL    DATEN


QEN         POP
            RETFIE

;*****************************************************************************
;*                              HAUPTPROGRAMM                                *
;*                              22.09.02                                     *
;*****************************************************************************
MAIN        BCF STATUS, RP0

;----------- INIT ALLE PORT'S ----------------------------------------------------

            CLRF    PORTA                           
            CLRF    PORTB
            MOVLW   0X07                    ;COMPARATORS ALLE AUS VOM PORT A
            MOVWF   CMCON
            BSF     STATUS, RP0             ;BANK1 
            MOVLW   B'11110001'             ;INIT INPUT/OUTPUT AM PORTA --> ALLES EINGAENGE AUSSER  RA1 RA2 RA3 ALS AUSGAENGE
            MOVWF   TRISA
            MOVLW   B'00001111'             ;INIT I/O PORTB ALLES AUSGAENGE FUER DATENBUS NUR RB0 BIS RB3 EINGNGE             
            MOVWF   TRISB
            BCF     STATUS, RP0             ;BANK0

;----------- INIT 15 SEC PAUSE DAMIT DCF-77-EMPFNGER GUT EINSCHWINGT -------------
;----------- ES WIRD TIMER1 GENOMMEN ---------------------------------------------
;----------- DIE ZEIT IST 500MS BIS DAS OVERFOW-BIT IN PIR1 (TMR1F) BIT0 ZU 1 WIRD
;DA JETZT KEIN 4MHZ QUARZ SONDERN 16MHZ QUARZ ALLES *4 
        
            CLRF    INTCON              ;TIMER1 KEIN INTERRUPT
            BSF     STATUS, RP0         ;BANK1
            CLRF    PIE1                ;INTERRUPT-ENABLE-BIT IST DISABLE (MASKE)
            BCF     STATUS, RP0         ;BANK0
            BCF     PIR1, TMR1IF        ;OVERFLOW 0 MACHEN
            MOVLW   0XDB                ;500MS/32=15.625MS/0.25MYS=62500TAKTE
            MOVWF   TMR1L               ;0X10000-62500(0XF424)=0X0BDC  +2(JUSTAGE 32T*2=64T)==0X0BDE
            MOVLW   0X0B
            MOVWF   TMR1H
            MOVLW   0X31                ;PRESCALE1:8 / SYSTEMCLOCK T/4 ==>1/32
            MOVWF   T1CON               ;START TIMER1

            CLRF    PORTA
            CLRF    PORTB

;ZEITSCHLEIFE VON 50MSEC, MUSS SEIN WEGEN ANSCHALTEN, DANN ERST DIE ERSTEN BEFEHLE
;DA JETZT KEIN 4MHZ QUARZ SONDERN 16MHZ QUARZ ALLES *4 MIT HELP0=4
            MOVLW   D'4'
            MOVWF   HELP0

S3          MOVLW   D'200'                  ;UNGEFAEHR 250SEC * 200 = 50MSEC
            MOVWF   HELP2

S0          MOVLW   D'250'                  ;UNGEFAEHR 250 SEC ZEITSCHLEIFE
            MOVWF   HELP1                   
S1          NOP                             ;T=4
            DECFSZ  HELP1, F                   ;T=4
            GOTO    S1                      ;T=4 ODER 8 ?
            DECFSZ  HELP2, F
            GOTO    S0          
            DECFSZ  HELP0, F
            GOTO    S3
;ENDE ZEITSCHLEIFE

;INITIALISIERUNG DOT-MATRIX-LCD
            MOVLW   H'20'                   ;FUNCTION SET  4-BIT-LAENGE, 1ZEILIG, 5X7FONT
            CALL    BEFEHL

            MOVLW   H'0C'                   ;DISPLAY ON/OFF   DISPLAY ON, CURSOR OFF, BLINK OFF
            CALL    BEFEHL

            MOVLW   H'01'                   ;CLEAR DISPLAY
            CALL    BEFEHL

;ZEITSCHLEIFE VON 2,5MSEC, MUSS SEIN WEGEN ANSCHALTEN, DANN ERST DIE ERSTEN BEFEHLE
;DA JETZT KEIN 4MHZ QUARZ SONDERN 16MHZ QUARZ ALLES *4 
            MOVLW   D'100'                   ;UNGEFAEHR 250SEC * 100 = 25,0MSEC  JETZT ABER 80
            MOVWF   HELP2

DD2         MOVLW   D'250'                  ;UNGEFAEHR 250 SEC ZEITSCHLEIFE
            MOVWF   HELP1
DD21        NOP
            DECFSZ  HELP1, F
            GOTO    DD21
            DECFSZ  HELP2, F
            GOTO    DD2          
;ENDE ZEITSCHLEIFE


;;;;;;;;NEU !!!!!!!!!!!!!!!!!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;TEST OB LED BRENNT

            BCF  PORTA, SCHALT

            ;BSF  PORTA, SCHALT

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;----------- LCD-DOT-MATRIX MINUSZEICHEN 8 STCK AUSGEBEN ------------------------

            MOVLW   H'80'                   ;ADRESSE 0 
            CALL    BEFEHL
            MOVLW   "G"
            CALL    DATEN

            MOVLW   H'81'                   ;ADRESSE 1
            CALL    BEFEHL
            MOVLW   "E"
            CALL    DATEN

            MOVLW   H'82'                   ;ADRESSE 2
            CALL    BEFEHL
            MOVLW   "H"
            CALL    DATEN

            MOVLW   H'83'                   ;ADRESSE 3
            CALL    BEFEHL
            MOVLW   "T"
            CALL    DATEN

            MOVLW   H'84'                   ;ADRESSE 4
            CALL    BEFEHL
            MOVLW   " "
            CALL    DATEN

            MOVLW   H'85'                   ;ADRESSE 5
            CALL    BEFEHL
            MOVLW   "L"
            CALL    DATEN

            MOVLW   H'86'                   ;ADRESSE 6
            CALL    BEFEHL
            MOVLW   "O"
            CALL    DATEN

            MOVLW   H'87'                   ;ADRESSE 7
            CALL    BEFEHL
            MOVLW   "S"
            CALL    DATEN


;----------- 15 SEC PAUSENZEIT ABFRAGEN ------------------------------------------
;DA JETZT KEIN 4MHZ QUARZ SONDERN 16MHZ QUARZ ALLES *4 
    
        MOVLW   D'120'              ;500MS*30=15SEC ALSO JETZT *4= 30*4=120
        MOVWF   HELP0
                                    ;JUSTAGE
PAUSE0  BTFSS   PIR1, TMR1IF        ;SPRUNG BEI OVERFLOW = 1;8T FLLBYTE UM AUF 64T ZU KOMMEN
        GOTO    PAUSE0
    
        BCF     T1CON, TMR1ON       ;STOP TIMER1        ;4T
        DECFSZ  HELP0, F            ;SPRUNG BEI 0       ;4T
        GOTO    PAUSE1              ;8T
        GOTO    E_PAUSE             ;2*4+3*8=32

PAUSE1  NOP                         ;4T
        NOP                         ;4T
        NOP                         ;4T
        BCF     PIR1, TMR1IF        ;OVERFLOW 0 MACHEN  ;4T
        MOVLW   0XD0                ;4T
        MOVWF   TMR1L               ;4T
        MOVLW   0X0B                ;4T
        MOVWF   TMR1H               ;4T
        MOVLW   0X31                ;4T
        MOVWF   T1CON               ;START TIMER1       ;4T GESAMT=64T
        GOTO    PAUSE0

;----------- INIT 0.5 SEC --------------------------------------------------------
;----------- ES WIRD TIMER1 GENOMMEN MIT INTERRUPT -------------------------------
;----------- ZEITBASIS DER NORMALEN QUARZ-UHR ------------------------------------

E_PAUSE

;;;;;;;;NEU !!!!!!!!!!!!!!!!!
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;TEST OB LED BRENNT

            ;BCF  PORTA, SCHALT

            ;BSF  PORTA, SCHALT




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        BSF     MERB, BIT0          ;ZULASSUNG WANN GESCHALTET WERDEN SOLL
        BCF     MERB, BIT7          ;MERKER FUER AUS-ZUSTAND VON RA1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

        BCF     PIR1, TMR1IF        ;4T OVERFLOW 0 MACHEN
        BSF     INTCON, GIE         ;4T GLOBALER INTERRUPT ENABLE + PERIPHERAL INTERRUPT
        BSF     INTCON, PEIE        ;4T
        BSF     STATUS, RP0         ;4T BANK1
        BSF     PIE1, TMR1IE        ;4T TIMER1 OVERFLOW-INTERRUPT ENABLE
        BCF     STATUS, RP0         ;4T BANK0
        MOVLW   0XDB                ;4T 500MS/32=15.625MS/0.25MYS=62500TAKTE
        MOVWF   TMR1L               ;4T 65536(0X10000)-62500(0XF424)=3036(0X0BDC)
                                    ;      +2(JUSTAGE 32T*2=64T)==0X0BDE
        MOVLW   0X0B                ;4T
        MOVWF   TMR1H               ;4T

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;1. JUSTAGE
;2,5SEC IN 15H ZU VIEL
;15H*60=900MIN*60=54000SEC*2=108000ZYKLEN
;2,5SEC/108000ZYK.=23.148MYKROSEC
;23.148MYKROSEC/0.25=92TAKTE ALSO T
;92/32T=2.8 GENOMMEN 3
;ALSO 0X0BD8+3=0X0BDB KEINE NOP'S

;2. JUSTAGE
;0,8 SEC IN 48H ZU VIEL
;48H*60=2880MIN*60=172800SEC*2=345600ZYKLEN
;0,8 SEC/ 345600ZYK.=2,314MYKROSEC
;2.314MYKROSEC/0.25=9.256TAKTE ALSO T
;9.256/4T=2.3 GENOMMEN 2 * NOP
;ALSO 2*NOP (8T) HINZUGEFGT

;3. JUSTAGE
;1 SEC IN 24H ZU WENIG
;24H*60=1440MIN*60=86400SEC*2=172800ZYKLEN
;1 SEC/ 172800ZYK.=5,787MYKROSEC
;5,787MYKROSEC/0.25=23,14TAKTE ALSO T
;23,14/4T=5,78 GENOMMEN 5 * NOP
;ALSO 5*NOP (20T) HINZUGEFGT

    NOP
    NOP
    
    NOP
    NOP
    NOP
    NOP
    NOP


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;





    MOVLW   0X31        ;4T PRESCALE1:8 / SYSTEMCLOCK T/4 ==>1/32
    MOVWF   T1CON       ;4T START TIMER1
                        ;GESAMT: 32T+13*4T=84T //20*0.25MYS=5MYS ZU LANG
    MOVLW   D'9'
    MOVWF   HELP0



;----------- GRUNDEINSTELLUNG FR NORMAL-QUARZ-UHR -------------------------------
;----------- UND ANZEIGE ---------------------------------------------------------


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;ANZEIGE RAUS GENOMMEN

            CLRF   H
 ;   MOVWF   PORTD


            CLRF   MIN
;    MOVWF   PORTB

            CLRF   SEC
;========================================================

            MOVLW   H'80'                   ;ADRESSE 0 
            CALL    BEFEHL
            MOVLW   H'20'
            CALL    DATEN

            MOVLW   H'81'                   ;ADRESSE 1
            CALL    BEFEHL
            MOVLW   H'30'
            CALL    DATEN

            MOVLW   H'82'                   ;ADRESSE 2
            CALL    BEFEHL
            MOVLW   H'3A'
            CALL    DATEN

            MOVLW   H'83'                   ;ADRESSE 3
            CALL    BEFEHL
            MOVLW   H'30'
            CALL    DATEN

            MOVLW   H'84'                   ;ADRESSE 4
            CALL    BEFEHL
            MOVLW   H'30'
            CALL    DATEN

            MOVLW   H'85'                   ;ADRESSE 5
            CALL    BEFEHL
            MOVLW   H'2E'
            CALL    DATEN

            MOVLW   H'86'                   ;ADRESSE 6
            CALL    BEFEHL
            MOVLW   H'30'
            CALL    DATEN

            MOVLW   H'87'                   ;ADRESSE 7
            CALL    BEFEHL
            MOVLW   H'30'
            CALL    DATEN

;========================================================


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

            CLRF    DCF_DA          ;DCF IST NICHT DA, ES BLINKT NICHT
;    BCF PORTB, FEHLER   ;FEHLERPUNKT NICHT DARSTELLEN

;            MOVLW   H'85'                  
;            CALL    BEFEHL
;            MOVLW   H'2E'
;            CALL    DATEN


            CLRF    MERK
            BSF     MERK, BIT6      ;BEI NICHT BEREINSTIMMUNG MIN/H 1.-TES OK ZULASSEN
                                    ;ABER NUR BEIM START

;----------- DCF-SIGNAL DECODIEREN -----------------------------------------------
;----------- DCF-SEC-IMPULS-ANFANG FINDEN ----------------------------------------

SYN         CLRF    ZUST
            CLRF    Z_LL
            CLRF    Z_LH

            BCF     DCF_DA, BIT0    ;DCF IST NICHT DA, ES BLINKT NICHT
;    BCF PORTB, FEHLER   ;FEHLERPUNKT NICHT DARSTELLEN

;            MOVLW   H'85'                  
;            CALL    BEFEHL
;            MOVLW   H'66'
;            CALL    DATEN


            MOVLW   D'4'
            MOVWF   X4
 
SEC0        BCF     INTCON, GIE ;INTERRUPT SPERREN, DA BANK1 VORKOMMT
            BTFSC   INTCON, GIE
            GOTO    SEC0
            MS1
            BSF     INTCON, GIE     ;INTERRUPT WIEDER ZULASSEN

SCHA        BTFSS   INTCON, T0IF    ;OVERFLOW 1MS
            GOTO    SCHA

            DECFSZ  X4, F
            GOTO    SEC0

            BTFSC   PORTA, BIT4
            GOTO    SEC1            ;HIGH-IMPULS-BEGINN ERKANNT
            INCF    Z_LL, F         ;LOW-IMPULS ZHLEN
            BTFSS   STATUS, Z       ;BERTRAG VON FF --> 00
            GOTO    SEC0
            BSF     Z_LH, BIT0
            GOTO    SEC0

SEC1        BTFSC   Z_LH, BIT0      ;GRER ALS FF LOW-SEC-LCKE
            GOTO    LUECKE

SEC2        MOVLW   0X02            ;GRER ALS 02 LOW-SEC-LCKE
            SUBWF   Z_LL, W
            BTFSS   STATUS, C
            GOTO    SYN

;------------ DCF-MINUTEN LCKE FINDEN ------------------------------------------

LUECKE      CLRF    Z_LL            ;MTE MIT HIGH IMPULS BEGINNEN
            CLRF    Z_LH            ;ES WERDEN NUR DIE LOW-ZEITEM GEMESSEN

L1          BTFSC   PORTA, BIT4
            GOTO    L2

            MOVLW   D'4'
            MOVWF   X4
 
LOOP1       BCF     INTCON, GIE     ;INTERRUPT SPERREN, DA BANK1 VORKOMMT
            BTFSC   INTCON, GIE
            GOTO    LOOP1
            MS1
            BSF     INTCON, GIE     ;INTERRUPT WIEDER ZULASSEN

SCH         BTFSS   INTCON, T0IF    ;OVERFLOW 1MS
            GOTO    SCH

            DECFSZ  X4, F
            GOTO    LOOP1

            INCFSZ  Z_LL, F
            GOTO    L1
            INCFSZ  Z_LH, F
            GOTO    L1
            GOTO    SYN             ;DCF IST NICHT DA, AUSWERTUNG NACH 0XFFFF 65.535MS
                                    ;ES BLINKT NICHT

L2          MOVLW   0X05            ;GRER ALS 0X0500 ALSO 1280MS
            SUBWF   Z_LH, W
            BTFSS   STATUS, C
            GOTO    LUECKE
 ;   BCF PORTB, FEHLER       ;FEHLERPUNKT NICHT DARSTELLEN

;            MOVLW   H'85'                  
;            CALL    BEFEHL
;            MOVLW   H'2E'
;            CALL    DATEN

            BSF DCF_DA, BIT0        ;ES BLINKT

;------------ DCF-IMPULSE ERFASSEN ---------------------------------------------

IMPULS  CLRF    Z_IMP       ;BEGINNT MIT HIGH-IMPULS
        CLRF    I_MIN
        CLRF    I_H
        CLRF    OK
        BSF     OK, BIT2    ;RAHMENFEHLER < > IST IN ORDNUNG, WIRD BEI FEHLER ZURCKGESETZT
        CLRF    PAR         ;UNGERADE PARITT BEGINN IST JETZT 0X00

I1      CLRF    Z_H
        CLRF    Z_LL
        CLRF    Z_LH

I2      BTFSS   PORTA, BIT4 ;HIGH-IMPULS MESSEN
        GOTO    I10         ;SPRUNG BEI LOW ZUR AUSWERTUNG

        MOVLW   D'4'
        MOVWF   X4
 
LOOP2   BCF INTCON, GIE     ;INTERRUPT SPERREN, DA BANK1 VORKOMMT
        BTFSC   INTCON, GIE
        GOTO    LOOP2
        MS1
        BSF INTCON, GIE     ;INTERRUPT WIEDER ZULASSEN

SCH1    BTFSS   INTCON, T0IF    ;OVERFLOW 1MS
        GOTO    SCH1

        DECFSZ  X4, F
        GOTO    LOOP2

        INCFSZ  Z_H, F          ;ACHTUNG HIER KNNTE FEHLER AUFTRETEN --> JETZT NICHT MEHR
        GOTO    I2
        GOTO    SYN

I10     AUSW                    ;AUSWERTUNG

;   MOVWF   PORTD

        INCF    Z_IMP, F

I111    BTFSC   PORTA, BIT4 ;LOW-IMPULS ZEITBERSCHREITUNG
        GOTO    I111A

        MOVLW   D'4'
        MOVWF   X4
 
LOOP3   BCF     INTCON, GIE     ;INTERRUPT SPERREN, DA BANK1 VORKOMMT
        BTFSC   INTCON, GIE
        GOTO    LOOP3
        MS1
        BSF     INTCON, GIE     ;INTERRUPT WIEDER ZULASSEN

SCH2    BTFSS   INTCON, T0IF    ;OVERFLOW 1MS
        GOTO    SCH2

        DECFSZ  X4, F
        GOTO    LOOP3

        INCFSZ  Z_LL, F
        GOTO    I111
        INCFSZ  Z_LH, F
        GOTO    I111
        GOTO    SYN             ;ZEITBERSCHREITUNG ES FEHLT DCF

I111A   MOVLW   0X05            ;GRER ALS 0X0500 ALSO 1280MS
        SUBWF   Z_LH, W
        BTFSS   STATUS, C
        GOTO    I1              ;ES IST EINE SEC VORBEI MIT HIGH + DANN LOW

;--------------- MINUTENLCKE AN DER RICHTIGEN STELLE ----------------------------

        MOVLW   D'59'       ;MIN-LCKEN ERKENNUNG OK???
        SUBWF   Z_IMP, W
        BTFSS   STATUS, Z
        GOTO    SCHB        ;FEHLER BEI IMPULSANZAHL

;--------------- OB KEIN FEHLER (PARITTBIT 0+1/RAHMEN <> BIT2) ------------------

        MOVLW   0X07
        SUBWF   OK, W
        BTFSS   STATUS, Z
        GOTO    SCHB        ;FEHLER BEI PARITT + RAHMEN

;--------------- OB ZEIT RICHTIG GEMESSEN, DANN DARSTELLEN ----------------------
    
        BTFSS   MERK, BIT6  ;BEI START SOFORT ZULASSEN
        GOTO    LLKM
        BCF MERK, BIT6
        GOTO    LOP11

LLKM    MOVLW   D'100'      ;BEI QUARZZEIT NICHT == GEMESSENER ZEIT
        SUBWF   ZUST, W
        BTFSS   STATUS, Z
        GOTO    NO          ;NICHT ZEIT DARSTELLEN, ZEIT NICHT RICHTIG GEMESSEN
                            ;KEINE BEREINSTIMMUNG

LOP11   CLRF    ZUST    ;JETZT GEHT NORMALE ZEITBEREINSTIMMUNG
        BSF MERK, BIT7      ;VON 00SEC ZU 01SEC FEHLERBLINKEN

;----------- QUARZ-ZEIT RICHTIG STARTEN ------------------------------------------

LOP1    BCF     INTCON, GIE ;INTERRUPT SPERREN, DA BANK1 VORKOMMT
        BTFSC   INTCON, GIE
        GOTO    LOP1
    
        BCF     T1CON, TMR1ON   ;STOP TIMER1        ;4T + 8TINTERRUPT? JUSTAGE
        BCF     PIR1, TMR1IF    ;OVERFLOW 0 MACHEN  ;4T
        BSF     INTCON, PEIE    ;ZUR SICHERHEIT PERIPH. INTERRUPT ZULASSEN
        MOVLW   0XDB        ;4T
        MOVWF   TMR1L       ;4T
        MOVLW   0X0B        ;4T
        MOVWF   TMR1H       ;4T
        MOVLW   0X31        ;+STEUERBITS FR DIESEN TIMER   ;4T
        MOVWF   T1CON       ;START TIMER1       ;4T GESAMT=14*4T + 1*8T=64T
    
        BSF     INTCON, GIE ;INTERRUPT WIEDER ZULASSEN

;----------- ZEIT EXAKT EINSTELLEN -----------------------------------------------
    
        CLRF    SEC         ;SEC NULLEN
        MOVF    I_MIN, W
        MOVWF   MIN
        MOVF    I_H, W
        MOVWF   H

;----------- MIN UND H ANZEIGE AUF LCD-PORT'S --------------------------------

;    MOVF    H, W        ;HIER ERFOLGT DIE VORNULLEN AUSBLENDUNG MIT 0XF?
;    ANDLW   0XF0        ;BEI 0X00 Z-FLAG GESETZT
;    BTFSS   STATUS, Z   ;SPRUNG BEI Z-FLAG GESETZT, ALSO BEI 0X0?, ALSO AUSBLENDEN
;    GOTO    BMM0

;    MOVF    H, W
;    ADDLW   0XF0
;    MOVWF   PORTD
;    GOTO    BMM1

;BMM0    MOVF    H, W
;    MOVWF   PORTD

;BMM1    MOVF    MIN, W
;    MOVWF   PORTB

;==========================================================
;SEC-DARSTELLEN
            MOVF    SEC, W                  
            MOVWF   HELP2

            MOVLW   H'87'                  
            CALL    BEFEHL
            
            MOVF    HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

            MOVLW   H'86'                  
            CALL    BEFEHL

            SWAPF   HELP2, W

            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

;MIN
            MOVF    MIN, W                  
            MOVWF   HELP2

            MOVLW   H'84'                  
            CALL    BEFEHL
            
            MOVF    HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

            MOVLW   H'83'                  
            CALL    BEFEHL

            SWAPF   HELP2, W

            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

;H
            MOVF    H, W                  
            MOVWF   HELP2

            MOVLW   H'81'                  
            CALL    BEFEHL
            
            MOVF    HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'
            CALL    DATEN

            MOVLW   H'80'                  
            CALL    BEFEHL

            SWAPF   HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'

            SUBLW   H'30'
            BTFSC   STATUS, Z
            GOTO    CCBN1

            SWAPF   HELP2, W
            ANDLW   H'0F'
            ADDLW   H'30'
            GOTO    CCCBN1

CCBN1       MOVLW   H'20'
CCCBN1      CALL    DATEN
 


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;NEU-PIC16F628
;DIE ABFRAGE DER SCHALTZEIT KOMMT HIER REIN
;----------------------------------------------------------

SSS10   BCF     MERB, BIT0           ;ZULASSUNG SCHALTEN BEI INTERRUPT

        BTFSC   MERB, BIT7      ;BEI AUS-ZUSTAND WIRD EINSCHALT-TABELLE ABGEFRAGT ....
        GOTO    AUS11

;VERGLEICHEN BEI EINSCHALTEN
        CLRF    ZAE             ;ZAEHLER BEGINNT BEI NULL
SPUCA1  CALL    SEC_EIN
        MOVWF   MERA
        MOVLW   H'04'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVLW   0XFF                ;ENDEERKENNUNG DER TABELLE
        SUBWF   MERA, W         ;DAS ENDEBYTE MUSS AM ENDE DER TABELLE FF HEX SEIN
        BTFSC   STATUS, Z
        GOTO    KMML1

        MOVLW   H'00'
        MOVWF   MERC
        MOVF    MERA, W
        SUBWF   MERC, W
        BTFSS   STATUS, Z
        GOTO    SPUC221

        CALL    H_EIN
        MOVWF   MERA
        MOVLW   H'04'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVF    MERA, W
        SUBWF   H, W
        BTFSS   STATUS, Z
        GOTO    SPUC221

        CALL    MIN_EIN
        MOVWF   MERA
        MOVLW   H'04'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVF    MERA, W
        SUBWF   MIN, W
        BTFSS   STATUS, Z
        GOTO    SPUC221
        
        BSF     PORTA, SCHALT       ;EINSCHALTEN DA SEC, MIN + H AUS TABELLE BEREINSTIMMT
        BSF     MERB, BIT7
        GOTO    KMML1

SPUC221 INCF    ZAE, F              ;ZAEHLER UM 1 ERHHEN
        GOTO    SPUCA1



;VERGLEICHEN BEI AUSSCHALTEN
AUS11   CLRF    ZAE             ;ZAEHLER BEGINNT BEI NULL
SPUKA1  CALL    SEC_AUS
        MOVWF   MERA
        MOVLW   H'04'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVLW   0XFF                ;ENDEERKENNUNG DER TABELLE
        SUBWF   MERA, W         ;DAS ENDEBYTE MUSS AM ENDE DER TABELLE FF HEX SEIN
        BTFSC   STATUS, Z
        GOTO    KMML1

        MOVLW   H'00'
        MOVWF   MERC
        MOVF    MERA, W
        SUBWF   MERC, W
        BTFSS   STATUS, Z
        GOTO    SPUK221

        CALL    H_AUS
        MOVWF   MERA
        MOVLW   H'04'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVF    MERA, W
        SUBWF   H, W
        BTFSS   STATUS, Z
        GOTO    SPUK221

        CALL    MIN_AUS
        MOVWF   MERA
        MOVLW   H'04'           ;ADRESSE SPEICHERN NEUES PCLATH
        MOVWF   PCLATH

        MOVF    MERA, W
        SUBWF   MIN, W
        BTFSS   STATUS, Z
        GOTO    SPUK221
        
        BCF     PORTA, SCHALT       ;AUSSCHALTEN DA SEC, MIN + H AUS TABELLE BEREINSTIMMT
        BCF     MERB, BIT7
        GOTO    KMML1

SPUK221 INCF    ZAE, F              ;ZAEHLER UM 1 ERHHEN
        GOTO    SPUKA1


;-------------------------------------------------------------
;ENDE DER ABFRAGE FR NEU-PIC16F628

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



KMML1       MOVLW   D'9'
            MOVWF   HELP0

;DOPPELPUNKT WIRD ANGEZEIGT
            MOVLW   H'82'                   
            CALL    BEFEHL
            MOVLW   H'3A'
            CALL    DATEN
        


;FEHLERPUNKT NICHT DARSTELLEN
NO          MOVLW   H'85'                  
            CALL    BEFEHL
            MOVLW   H'2E'
            CALL    DATEN


            BSF     DCF_DA, BIT0    ;ES BLINKT
            GOTO    IMPULS          ;ES IST 1MIN VORBEI HIER IST MIN-LCKE ERKANNT

SCHB        CLRF    ZUST

;FEHLERPUNKT NICHT DARSTELLEN
            MOVLW   H'85'                  
            CALL    BEFEHL
            MOVLW   H'2E'
            CALL    DATEN


            BSF     DCF_DA, BIT0    ;ES BLINKT
            GOTO    IMPULS


;*****************************************************************************
;*                              UNTERPRG. (H UND MIN +1)                     *
;*                              09.10.02                                     *
;*****************************************************************************
PLUS1   MOVF    MIN_V, W
        ANDLW   0X0F
        ADDLW   0X01
        SUBLW   0X0A
        BTFSS   STATUS, Z
        GOTO    JPP2
    
        MOVF    MIN_V, W
        ANDLW   0XF0
        ADDLW   0X10
        GOTO    JPP3

JPP2    MOVF    MIN_V, W
        ADDLW   0X01

JPP3    MOVWF   MIN_V
        SUBLW   0X60
        BTFSS   STATUS, Z
        GOTO    EEEND
    
        MOVWF   MIN_V
        MOVF    H_V, W
        ANDLW   0X0F
        ADDLW   0X01
        SUBLW   0X0A
        BTFSS   STATUS, Z
        GOTO    JPP4
    
        MOVF    H_V, W
        ANDLW   0XF0
        ADDLW   0X10
        GOTO    JPP5

JPP4    MOVF    H_V, W
        ADDLW   0X01

JPP5    MOVWF   H_V
        SUBLW   0X24
        BTFSS   STATUS, Z
        GOTO    EEEND
        MOVWF   H_V

EEEND   RETURN


;*****************************************************************************
;*                              DATEN AUSGEBEN AUF DOT-LCD-MODUL             *
;*                              04.05.10                                     *
;*****************************************************************************
DATEN       BSF     PORTA, RS               ;ALS DATEN

            MOVWF   BIT

            MOVF    PORTB, W
            ANDLW   0X0F
            MOVWF   MERKE

            MOVF    BIT, W
            ANDLW   0XF0
            ADDWF   MERKE, W
            MOVWF   PORTB


            BSF     PORTA, EN

;ZEITSCHLEIFE 4SEC
            MOVLW   D'4'                    ;UNGEFAEHR 4SEC ZEITSCHLEIFE
            MOVWF   HELP1
D1          NOP                             ;T=4
            DECFSZ  HELP1, F                ;T=4
            GOTO    D1                      ;T=8    GES.:16TAKTE * 0,0625SEC= 1SEC    *4 DURCHLAEUFE= 4SEC
;ENDE ZEITSCHLEIFE
 
            BCF     PORTA, EN

;---------------------------------

;LOW 4BIT AUSGEBEN
            RLF     BIT, F
            RLF     BIT, F
            RLF     BIT, F
            RLF     BIT, F

            MOVF    PORTB, W
            ANDLW   0X0F
            MOVWF   MERKE

            MOVF    BIT, W
            ANDLW   0XF0
            ADDWF   MERKE, W
            MOVWF   PORTB


            BSF     PORTA, EN

;ZEITSCHLEIFE 4SEC
            MOVLW   D'4'                    
            MOVWF   HELP1
DDD1        NOP                             
            DECFSZ  HELP1, F                
            GOTO    DDD1                    
;ENDE ZEITSCHLEIFE
 
            BCF     PORTA, EN

;ZEITSCHLEIFE 40SEC
            MOVLW   D'40'                   ;UNGEFAEHR 40SEC ZEITSCHLEIFE
            MOVWF   HELP1
DDDD1       NOP
            DECFSZ  HELP1, F                ;WIE OBEN  
            GOTO    DDDD1
;ENDE ZEITSCHLEIFE



            RETURN

;*****************************************************************************
;*                              BEFEHL AUSGEBEN AUF DOT-LCD-MODUL            *
;*                              04.05.10                                     *
;*****************************************************************************
BEFEHL      BCF     PORTA, RS                ;ALS BEFEHL

            MOVWF   BIT

            MOVF    PORTB, W
            ANDLW   0X0F
            MOVWF   MERKE

            MOVF    BIT, W
            ANDLW   0XF0
            ADDWF   MERKE, W
            MOVWF   PORTB

            BSF     PORTA, EN

;ZEITSCHLEIFE 4SEC
            MOVLW   D'4'                    ;UNGEFAEHR 8SEC ZEITSCHLEIFE
            MOVWF   HELP1
B1          NOP                             ;T=4
            DECFSZ  HELP1, F                ;T=4
            GOTO    B1                      ;T=8        GES.:16TAKTE * 0,0625SEC= 1SEC    *4 DURCHLAEUFE= 4SEC
;ENDE ZEITSCHLEIFE
 
            BCF     PORTA, EN

;---------------------------------

;LOW 4BIT AUSGEBEN
            RLF     BIT, F
            RLF     BIT, F
            RLF     BIT, F
            RLF     BIT, F

            MOVF    PORTB, W
            ANDLW   0X0F
            MOVWF   MERKE

            MOVF    BIT, W
            ANDLW   0XF0
            ADDWF   MERKE, W
            MOVWF   PORTB

            BSF     PORTA, EN

;ZEITSCHLEIFE 4SEC
            MOVLW   D'4'                    
            MOVWF   HELP1
BBB1        NOP                             
            DECFSZ  HELP1, F                
            GOTO    BBB1                    
;ENDE ZEITSCHLEIFE
 
            BCF     PORTA, EN

;ZEITSCHLEIFE 40SEC
            MOVLW   D'40'                   ;UNGEFAEHR 40SEC ZEITSCHLEIFE
            MOVWF   HELP1
BBBB1       NOP
            DECFSZ  HELP1, F                ;WIE OBEN  
            GOTO    BBBB1
;ENDE ZEITSCHLEIFE
 
            RETURN


;=====================================================================================


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;*****************************************************************************
;*                       TABELLE FUER ALLE STUNDEN SCHALTEN EIN              *
;*                              25.03.10                                     *
;*****************************************************************************
        ORG 0X0500
H_EIN   MOVLW H'05'     ;ADRESSE SPEICHERN NEUES PCLATH ALSO 0X500
        MOVWF PCLATH

        MOVF  ZAE,W     ;ZAEHLER IN W
        ADDWF PCL,F     ;AUF STELLE DES ZU LESENDEN BYTES BRINGEN 

;AB EINEM SEMIKOLON BIS ZUM ZEILEN-ENDE WIRKT DAS GESCHRIEBENE NUR ALS KOMMENTAR
                      
;HIER STEHEN DIE BCD-STUNDEN DRIN FR DAS EIN-SCHALTEN   
        ;RETLW H'07';7:00.00 EIN / 7:00.04 AUS
        ;RETLW H'07';7:15.00 EIN / 7:15.04 AUS

        ;RETLW H'07';7:30.00 EIN / 7:30.04 AUS
        ;RETLW H'07';7:45.00 EIN / 7:45.04 AUS
        RETLW H'08';8:00.00 EIN / 8:00.04 AUS
        RETLW H'08';8:59.50 EIN / 9:04.40 AUS
        RETLW H'09';9:59.50 EIN / 10:04.40 AUS
        RETLW H'10';10:59.50 EIN / 11:04.40 AUS
        RETLW H'11';11:59.50 EIN / 12:04.40 AUS
        RETLW H'12';12:59.50 EIN / 13:04.40 AUS

        RETLW H'13';13:59.50 EIN / 14:04.40 AUS
        RETLW H'14';14:59.50 EIN / 15:04.40 AUS
        RETLW H'15';15:59.50 EIN / 16:04.40 AUS
        RETLW H'16';16:59.50 EIN / 17:04.40 AUS
        RETLW H'17';17:59.50 EIN / 18:04.40 AUS
        RETLW H'18';18:59.50 EIN / 19:04.40 AUS
        RETLW H'19';19:59.50 EIN / 20:04.40 AUS
        RETLW H'20';20:59.50 EIN / 21:04.40 AUS
;        RETLW H'21';21:59.50 EIN / 22:04.40 AUS

;JEDE HALBE STUNDE
        RETLW H'08';8:29:45 EIN   /    8:33:00 AUS
        RETLW H'09';9:29:45 EIN   /    9:33:00 AUS
        RETLW H'10';10:29:45 EIN  /   10:33:00 AUS
        RETLW H'11';11:29:45 EIN  /   11:33:00 AUS
        RETLW H'12';12:29:45 EIN  /   12:33:00 AUS
        RETLW H'13';13:29:45 EIN  /   13:33:00 AUS
        RETLW H'14';14:29:45 EIN  /   14:33:00 AUS
        RETLW H'15';15:29:45 EIN  /   15:33:00 AUS
        RETLW H'16';16:29:45 EIN  /   16:33:00 AUS
        RETLW H'17';17:29:45 EIN  /   17:33:00 AUS
        RETLW H'18';18:29:45 EIN  /   18:33:00 AUS
        RETLW H'19';19:29:45 EIN  /   19:33:00 AUS
        RETLW H'20';20:29:45 EIN  /   20:33:00 AUS




        RETLW 0XFF      ;ENDEKENNZEICHEN    

;*****************************************************************************
;*                       TABELLE FUER ALLE MINUTEN SCHALTEN EIN              *
;*                              25.03.10                                     *
;*****************************************************************************
        ORG 0X0580
MIN_EIN MOVLW H'05'     ;ADRESSE SPEICHERN NEUES PCLATH ALSO 0X500
        MOVWF PCLATH

        MOVF  ZAE,W     ;ZAEHLER IN W
        ADDWF PCL,F     ;AUF STELLE DES ZU LESENDEN BYTES BRINGEN 

;AB EINEM SEMIKOLON BIS ZUM ZEILEN-ENDE WIRKT DAS GESCHRIEBENE NUR ALS KOMMENTAR
 
;HIER STEHEN DIE BCD-MINUTEN DRIN FR DAS EIN-SCHALTEN                 
        ;RETLW H'00';7:00.00 EIN / 7:00.04 AUS
        ;RETLW H'15';7:15.00 EIN / 7:15.04 AUS

        ;RETLW H'30';7:30.00 EIN / 7:30.04 AUS
        ;RETLW H'45';7:45.00 EIN / 7:45.04 AUS
        RETLW H'00';8:00.00 EIN / 8:00.04 AUS
        RETLW H'59';8:59.50 EIN / 9:04.40 AUS
        RETLW H'59';9:59.50 EIN / 10:04.40 AUS
        RETLW H'59';10:59.50 EIN / 11:04.40 AUS
        RETLW H'59';11:59.50 EIN / 12:04.40 AUS
        RETLW H'59';12:59.50 EIN / 13:04.40 AUS

        RETLW H'59';13:59.50 EIN / 14:04.40 AUS
        RETLW H'59';14:59.50 EIN / 15:04.40 AUS
        RETLW H'59';15:59.50 EIN / 16:04.40 AUS
        RETLW H'59';16:59.50 EIN / 17:04.40 AUS
        RETLW H'59';17:59.50 EIN / 18:04.40 AUS
        RETLW H'59';18:59.50 EIN / 19:04.40 AUS
        RETLW H'59';19:59.50 EIN / 20:04.40 AUS
        RETLW H'59';20:59.50 EIN / 21:04.40 AUS
;        RETLW H'59';21:59.50 EIN / 22:04.40 AUS

;JEDE HALBE STUNDE
        RETLW H'29';8:29:45 EIN   /    8:33:00 AUS
        RETLW H'29';9:29:45 EIN   /    9:33:00 AUS
        RETLW H'29';10:29:45 EIN  /   10:33:00 AUS
        RETLW H'29';11:29:45 EIN  /   11:33:00 AUS
        RETLW H'29';12:29:45 EIN  /   12:33:00 AUS
        RETLW H'29';13:29:45 EIN  /   13:33:00 AUS
        RETLW H'29';14:29:45 EIN  /   14:33:00 AUS
        RETLW H'29';15:29:45 EIN  /   15:33:00 AUS
        RETLW H'29';16:29:45 EIN  /   16:33:00 AUS
        RETLW H'29';17:29:45 EIN  /   17:33:00 AUS
        RETLW H'29';18:29:45 EIN  /   18:33:00 AUS
        RETLW H'29';19:29:45 EIN  /   19:33:00 AUS
        RETLW H'29';20:29:45 EIN  /   20:33:00 AUS


        RETLW 0XFF      ;ENDEKENNZEICHEN    

;*****************************************************************************
;*                       TABELLE FUER ALLE SEKUNDEN SCHALTEN EIN             *
;*                              25.03.10                                     *
;*****************************************************************************
        ORG 0X0600
SEC_EIN MOVLW H'06'     ;ADRESSE SPEICHERN NEUES PCLATH ALSO 0X600
        MOVWF PCLATH

        MOVF  ZAE,W     ;ZAEHLER IN W
        ADDWF PCL,F     ;AUF STELLE DES ZU LESENDEN BYTES BRINGEN 

;AB EINEM SEMIKOLON BIS ZUM ZEILEN-ENDE WIRKT DAS GESCHRIEBENE NUR ALS KOMMENTAR
                 
;HIER STEHEN DIE BCD-SEKUNDEN DRIN FR DAS EIN-SCHALTEN  
        ;RETLW H'00';7:00.00 EIN / 7:00.04 AUS
        ;RETLW H'00';7:15.00 EIN / 7:15.04 AUS

        ;RETLW H'00';7:30.00 EIN / 7:30.04 AUS
        ;RETLW H'00';7:45.00 EIN / 7:45.04 AUS
        RETLW H'00';8:00.00 EIN / 8:00.04 AUS
        RETLW H'50';8:59.50 EIN / 9:04.40 AUS
        RETLW H'50';9:59.50 EIN / 10:04.40 AUS
        RETLW H'50';10:59.50 EIN / 11:04.40 AUS
        RETLW H'50';11:59.50 EIN / 12:04.40 AUS
        RETLW H'50';12:59.50 EIN / 13:04.40 AUS

        RETLW H'50';13:59.50 EIN / 14:04.40 AUS
        RETLW H'50';14:59.50 EIN / 15:04.40 AUS
        RETLW H'50';15:59.50 EIN / 16:04.40 AUS
        RETLW H'50';16:59.50 EIN / 17:04.40 AUS
        RETLW H'50';17:59.50 EIN / 18:04.40 AUS
        RETLW H'50';18:59.50 EIN / 19:04.40 AUS
        RETLW H'50';19:59.50 EIN / 20:04.40 AUS
        RETLW H'50';20:59.50 EIN / 21:04.40 AUS
;        RETLW H'21';21:59.50 EIN / 22:04.40 AUS

;JEDE HALBE STUNDE
        RETLW H'45';8:29:45 EIN   /    8:33:00 AUS
        RETLW H'45';9:29:45 EIN   /    9:33:00 AUS
        RETLW H'45';10:29:45 EIN  /   10:33:00 AUS
        RETLW H'45';11:29:45 EIN  /   11:33:00 AUS
        RETLW H'45';12:29:45 EIN  /   12:33:00 AUS
        RETLW H'45';13:29:45 EIN  /   13:33:00 AUS
        RETLW H'45';14:29:45 EIN  /   14:33:00 AUS
        RETLW H'45';15:29:45 EIN  /   15:33:00 AUS
        RETLW H'45';16:29:45 EIN  /   16:33:00 AUS
        RETLW H'45';17:29:45 EIN  /   17:33:00 AUS
        RETLW H'45';18:29:45 EIN  /   18:33:00 AUS
        RETLW H'45';19:29:45 EIN  /   19:33:00 AUS
        RETLW H'45';20:29:45 EIN  /   20:33:00 AUS

        RETLW 0XFF      ;ENDEKENNZEICHEN

;*****************************************************************************
;*                       TABELLE FUER ALLE STUNDEN SCHALTEN AUS              *
;*                              25.03.10                                     *
;*****************************************************************************
        ORG 0X0680
H_AUS   MOVLW H'06'     ;ADRESSE SPEICHERN NEUES PCLATH ALSO 0X600
        MOVWF PCLATH

        MOVF  ZAE,W     ;ZAEHLER IN W
        ADDWF PCL,F     ;AUF STELLE DES ZU LESENDEN BYTES BRINGEN 

;AB EINEM SEMIKOLON BIS ZUM ZEILEN-ENDE WIRKT DAS GESCHRIEBENE NUR ALS KOMMENTAR
                 
;HIER STEHEN DIE BCD-STUNDEN DRIN FR DAS AUS-SCHALTEN   
        ;RETLW H'07';7:00.00 EIN / 7:00.04 AUS
        ;RETLW H'07';7:15.00 EIN / 7:15.04 AUS

        ;RETLW H'07';7:30.00 EIN / 7:30.04 AUS
        ;RETLW H'07';7:45.00 EIN / 7:45.04 AUS
        RETLW H'08';8:00.00 EIN / 8:00.04 AUS
        RETLW H'09';8:59.50 EIN / 9:04.40 AUS
        RETLW H'10';9:59.50 EIN / 10:04.40 AUS
        RETLW H'11';10:59.50 EIN / 11:04.40 AUS
        RETLW H'12';11:59.50 EIN / 12:04.40 AUS
        RETLW H'13';12:59.50 EIN / 13:04.40 AUS

        RETLW H'14';13:59.50 EIN / 14:04.40 AUS
        RETLW H'15';14:59.50 EIN / 15:04.40 AUS
        RETLW H'16';15:59.50 EIN / 16:04.40 AUS
        RETLW H'17';16:59.50 EIN / 17:04.40 AUS
        RETLW H'18';17:59.50 EIN / 18:04.40 AUS
        RETLW H'19';18:59.50 EIN / 19:04.40 AUS
        RETLW H'20';19:59.50 EIN / 20:04.40 AUS
        RETLW H'21';20:59.50 EIN / 21:04.40 AUS
;        RETLW H'21';21:59.50 EIN / 22:04.40 AUS

;JEDE HALBE STUNDE
        RETLW H'08';8:29:45 EIN   /    8:33:00 AUS
        RETLW H'09';9:29:45 EIN   /    9:33:00 AUS
        RETLW H'10';10:29:45 EIN  /   10:33:00 AUS
        RETLW H'11';11:29:45 EIN  /   11:33:00 AUS
        RETLW H'12';12:29:45 EIN  /   12:33:00 AUS
        RETLW H'13';13:29:45 EIN  /   13:33:00 AUS
        RETLW H'14';14:29:45 EIN  /   14:33:00 AUS
        RETLW H'15';15:29:45 EIN  /   15:33:00 AUS
        RETLW H'16';16:29:45 EIN  /   16:33:00 AUS
        RETLW H'17';17:29:45 EIN  /   17:33:00 AUS
        RETLW H'18';18:29:45 EIN  /   18:33:00 AUS
        RETLW H'19';19:29:45 EIN  /   19:33:00 AUS
        RETLW H'20';20:29:45 EIN  /   20:33:00 AUS

        RETLW 0XFF      ;ENDEKENNZEICHEN

;*****************************************************************************
;*                       TABELLE FUER ALLE MINUTEN SCHALTEN AUS              *
;*                              25.03.10                                     *
;*****************************************************************************
        ORG 0X0700
MIN_AUS MOVLW H'07'     ;ADRESSE SPEICHERN NEUES PCLATH ALSO 0X700
        MOVWF PCLATH

        MOVF  ZAE,W     ;ZAEHLER IN W
        ADDWF PCL,F     ;AUF STELLE DES ZU LESENDEN BYTES BRINGEN 
 
;AB EINEM SEMIKOLON BIS ZUM ZEILEN-ENDE WIRKT DAS GESCHRIEBENE NUR ALS KOMMENTAR
                
;HIER STEHEN DIE BCD-MINUTEN DRIN FR DAS AUS-SCHALTEN    
        ;RETLW H'00';7:00.00 EIN / 7:00.04 AUS
        ;RETLW H'15';7:15.00 EIN / 7:15.04 AUS

        ;RETLW H'30';7:30.00 EIN / 7:30.04 AUS
        ;RETLW H'45';7:45.00 EIN / 7:45.04 AUS
        RETLW H'00';8:00.00 EIN / 8:00.04 AUS
        RETLW H'04';8:59.50 EIN / 9:04.40 AUS
        RETLW H'04';9:59.50 EIN / 10:04.40 AUS
        RETLW H'04';10:59.50 EIN / 11:04.40 AUS
        RETLW H'04';11:59.50 EIN / 12:04.40 AUS
        RETLW H'04';12:59.50 EIN / 13:04.40 AUS

        RETLW H'04';13:59.50 EIN / 14:04.40 AUS
        RETLW H'04';14:59.50 EIN / 15:04.40 AUS
        RETLW H'04';15:59.50 EIN / 16:04.40 AUS
        RETLW H'04';16:59.50 EIN / 17:04.40 AUS
        RETLW H'04';17:59.50 EIN / 18:04.40 AUS
        RETLW H'04';18:59.50 EIN / 19:04.40 AUS
        RETLW H'04';19:59.50 EIN / 20:04.40 AUS
        RETLW H'04';20:59.50 EIN / 21:04.40 AUS
;        RETLW H'21';21:59.50 EIN / 22:04.40 AUS

;JEDE HALBE STUNDE
        RETLW H'33';8:29:45 EIN   /    8:33:00 AUS
        RETLW H'33';9:29:45 EIN   /    9:33:00 AUS
        RETLW H'33';10:29:45 EIN  /   10:33:00 AUS
        RETLW H'33';11:29:45 EIN  /   11:33:00 AUS
        RETLW H'33';12:29:45 EIN  /   12:33:00 AUS
        RETLW H'33';13:29:45 EIN  /   13:33:00 AUS
        RETLW H'33';14:29:45 EIN  /   14:33:00 AUS
        RETLW H'33';15:29:45 EIN  /   15:33:00 AUS
        RETLW H'33';16:29:45 EIN  /   16:33:00 AUS
        RETLW H'33';17:29:45 EIN  /   17:33:00 AUS
        RETLW H'33';18:29:45 EIN  /   18:33:00 AUS
        RETLW H'33';19:29:45 EIN  /   19:33:00 AUS
        RETLW H'33';20:29:45 EIN  /   20:33:00 AUS

        RETLW 0XFF      ;ENDEKENNZEICHEN

;*****************************************************************************
;*                       TABELLE FUER ALLE SEKUNDEN SCHALTEN AUS             *
;*                              25.03.10                                     *
;*****************************************************************************
        ORG 0X0780
SEC_AUS MOVLW H'07'     ;ADRESSE SPEICHERN NEUES PCLATH ALSO 0X700
        MOVWF PCLATH

        MOVF  ZAE,W     ;ZAEHLER IN W
        ADDWF PCL,F     ;AUF STELLE DES ZU LESENDEN BYTES BRINGEN 

;AB EINEM SEMIKOLON BIS ZUM ZEILEN-ENDE WIRKT DAS GESCHRIEBENE NUR ALS KOMMENTAR
                
;HIER STEHEN DIE BCD-SEKUNDEN DRIN FR DAS AUS-SCHALTEN 
        ;RETLW H'04';7:00.00 EIN / 7:00.04 AUS
        ;RETLW H'04';7:15.00 EIN / 7:15.04 AUS

        ;RETLW H'04';7:30.00 EIN / 7:30.04 AUS
        ;RETLW H'04';7:45.00 EIN / 7:45.04 AUS
        RETLW H'04';8:00.00 EIN / 8:00.04 AUS
        RETLW H'40';8:59.50 EIN / 9:04.40 AUS
        RETLW H'40';9:59.50 EIN / 10:04.40 AUS
        RETLW H'40';10:59.50 EIN / 11:04.40 AUS
        RETLW H'40';11:59.50 EIN / 12:04.40 AUS
        RETLW H'40';12:59.50 EIN / 13:04.40 AUS

        RETLW H'40';13:59.50 EIN / 14:04.40 AUS
        RETLW H'40';14:59.50 EIN / 15:04.40 AUS
        RETLW H'40';15:59.50 EIN / 16:04.40 AUS
        RETLW H'40';16:59.50 EIN / 17:04.40 AUS
        RETLW H'40';17:59.50 EIN / 18:04.40 AUS
        RETLW H'40';18:59.50 EIN / 19:04.40 AUS
        RETLW H'40';19:59.50 EIN / 20:04.40 AUS
        RETLW H'40';20:59.50 EIN / 21:04.40 AUS
;        RETLW H'21';21:59.50 EIN / 22:04.40 AUS

;JEDE HALBE STUNDE
        RETLW H'00';8:29:45 EIN   /    8:33:00 AUS
        RETLW H'00';9:29:45 EIN   /    9:33:00 AUS
        RETLW H'00';10:29:45 EIN  /   10:33:00 AUS
        RETLW H'00';11:29:45 EIN  /   11:33:00 AUS
        RETLW H'00';12:29:45 EIN  /   12:33:00 AUS
        RETLW H'00';13:29:45 EIN  /   13:33:00 AUS
        RETLW H'00';14:29:45 EIN  /   14:33:00 AUS
        RETLW H'00';15:29:45 EIN  /   15:33:00 AUS
        RETLW H'00';16:29:45 EIN  /   16:33:00 AUS
        RETLW H'00';17:29:45 EIN  /   17:33:00 AUS
        RETLW H'00';18:29:45 EIN  /   18:33:00 AUS
        RETLW H'00';19:29:45 EIN  /   19:33:00 AUS
        RETLW H'00';20:29:45 EIN  /   20:33:00 AUS

        RETLW 0XFF      ;ENDEKENNZEICHEN

                                    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;





            END
