;****************************************************************************************
;*                           BATTERIE-ABSCHALTUNG                                       * 
;*                           ====================                                       *
;*                                                                                      *
;****************************************************************************************

        LIST    P=16F88       
        TITLE   "BATTERIE-ABSCHALT"

        ERRORLEVEL -302
        INCLUDE <P16F88.INC>

__CONFIG _CONFIG1, _CP_OFF & _CCPMX_RB0 & _DEBUG_OFF & _WRT_OFF & _CPD_OFF & _LVP_OFF & _BOREN_ON & _MCLRE_OFF & _PWRTE_OFF & _WDTE_OFF & _INTRC_IO
__CONFIG _CONFIG2, _IESO_OFF & _FCMEN_OFF


;--------------------------------------------------------------------------
;REGISTER ZUORDNEN NACH DEM DIE FESTEN-REGISTER ZU ENDE SIND
;ES GEHT ALSO ERST AB 22 HEX LOS
;DIES IST ALSO DIE RAM-SPEICHER ZUORDNUNG

HELP0   EQU 0X22       ;HILFSZELLE
HELP1   EQU 0X23       ;HILFSZELLE  

ZUSTAND EQU 0X24       ;BIT0 = FUER HYSTERESE AKTIV MIT HIGH / 
                       ;BIT7 = BEI HIGH == ES BLINKT GN MIT TASTER
                       ;BIT1 = HIGH NEUSTART NACH BLINKEN MIT TASTER / BLINKEN GN AUS
                       ;BIT2 = BEI HIGH ZEIT ERREICHT / ES BLINKT MIT DAUERABSCHALTUNG
                       
;ANALOG/DIGITAL-WANDLUNG
AD_H    EQU 0X25
AD_L    EQU 0X26
 
;SCHALTSPANNUNGEN FR MOSFET EIN AUS
SCHALT_AUS EQU 0X27
SCHALT_EIN EQU 0X28  ;HIER IST HYSTERESE BERECHNET 
 
ZEIT    EQU 0X29    ;ZEIT BIS DAUERABSCHALTUNG
SEC     EQU 0X2A    

;FR INTERRUPT
W_STACK EQU 0X2B
S_STACK EQU 0X2C
 
MULTI   EQU 0X2D    ;ZEIT MULTI 200MSEC WERDEN ZU 1SEC
BLINK   EQU 0X2E    ;ABWECHSELND 200MSEC BLINKEN MIT BIT0
AUS     EQU 0X2F    ;LED-ANZEIGE BEIM MESSEN AUS MIT BIT0
HELP3   EQU 0X30    ;BEI DAUER-BLINK HILFSZELLE     
HELP4   EQU 0X31
HELP5   EQU 0X32   
   
;------------------------- MACROS -----------------------------------------

BANK0           MACRO                   ;MACRO TO SELECT DATA RAM BANK 0
                BCF     STATUS,RP0
                BCF     STATUS,RP1
                ENDM

BANK1           MACRO                   ;MACRO TO SELECT DATA RAM BANK 1
                BSF     STATUS,RP0
                BCF     STATUS,RP1
                ENDM

BANK2           MACRO                   ;MACRO TO SELECT DATA RAM BANK 2
                BCF     STATUS,RP0
                BSF     STATUS,RP1
                ENDM

BANK3           MACRO                   ;MACRO TO SELECT DATA RAM BANK 3
                BSF     STATUS,RP0
                BSF     STATUS,RP1
                ENDM

;------------ MACROS FUER INTERRUPT -----------------------------------------
;WENN EINE UNTERBRECHUNG VOM EIGENTLICHEN PROGRAMM KOMMT, MUSS REGISTER "W" UND "STATUS" GERETTET/GEMERKT WERDEN.
;DIES PASSIERT MITTELS RAM-SPEICHERZELLEN W_STACK UND S_STACK

PUSH    MACRO
        MOVWF   W_STACK
        MOVF    STATUS, W
        MOVWF   S_STACK
        ENDM
;----------------------------------------------------------------------------

;WENN DAS INTERRUPT-PROGRAMM ABGEARBEITET IST (ZU ENDE IST), MSSEN DIE GEMERKTEN/GERETTEN REGISTER "W" UND "STATUS"
;WIEDER HERVORGEHOLT WERDEN, UM IM EIGENTLICHEN PROGRAMM WEITER ZU ARBEITEN

POP     MACRO
        MOVF    S_STACK, W
        MOVWF   STATUS
        SWAPF   W_STACK, F
        SWAPF   W_STACK, W
        ENDM
;----------------------------------------------------------------------------

;VARIABLEN
BIT7    EQU 7       ; BIT 7
BIT6    EQU 6       ; BIT 6
BIT5    EQU 5       ; BIT 5
BIT4    EQU 4       ; BIT 4
BIT3    EQU 3       ; BIT 3 
BIT2    EQU 2       ; BIT 2
BIT1    EQU 1       ; BIT 1 
BIT0    EQU 0       ; BIT 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;SPANNUNGSBERECHNUNG VON DER AD-WANDUNG AM SPANNUNGSTEILER 3,9KOHM UND 10KOHM
;
;
;BEI 13,0V LIEGEN AN 
;ALSO DURCH SPANNUNGTEILER ERGIBT SICH FOLGENDE SPANNUNG:
;SCHALTSPANNUNG * (3,9 : (3,9+10))= XXX VOLT  
;13,0V * (3,9 : (3,9+10))= 3,6474 VOLT
;
;BERECHNUNG DER WERTE WELCHE IM PROGRAMM VERWENDET WERDEN:
;ES GILT: 1023DEZ 0X03FFHEX SIND 5,0V
;ES ERGIBT SICH DARAUS MIT PROPORTION:
;(1023 * SPANNUNG-VOM-SPANNUNGSTEILER) : 5,0VOLT = XXX DEZIMAL
;
;(1023*3,6474V):5,0V=746DEZ  DANN UMRECHNEN AM TASCHENRECHNER VON DEZ AUF HEX ,,, 746DEZ=2EAHEX = ODER SO GESCHRIEBEN 0X02EA
;13,0V  AM R-TEILER 3,6474 VOLT = 746DEZ 0X02EA ALSO DIE HEX-WERTE 0X02 ALS HIGH  UND 0XEA ALS LOW
;
;ERGEBNIS:
;DIE HEX-WERTE HIGH-BYTE=0X02 UND LOW-BYTE=0XEA
;DIESE 2BYTE HEX-WERTE WURDEN IM PROGRAMM BENUTZT
;WILL MAN AENDERN MUSS MAN DIESE WERTE AENDERN !!!!!!!!

;ERGEBNIS FUER ==> BEI 13,0V     
;LED_H     EQU     0X02
;LED_L     EQU     0XEA  

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;BATTERIE-SPANNUNUNGEN;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;                  1-ZELLE  6-ZELLEN  
;LADE-ANFANG:      2,04V    12,24V    
;LADE-SCHLUSS:     2,78V    16,68V    

;ENTLADE-ANFANG:   2,20V    13,20V    
;ENTLADE-SCHLUSS:  1,80V    10,80V    

;GELADEN UND ENT-LADEN WIRD MIT 0,1 * X AMPER-STUNDEN(KAPAZITAET)  

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;SCHALTSPANNUNGEN DES MOSFET AN AN1:

;ES GILT IMMER FUER HIGH-BYTE UND LOW-BYTE
;IMMER HIGH-BYTE == SCHALT_H   EQU 0X02 
;MIT BERECHNUNG UND DANN AUSPROBIEREN: 
SCHALT110   EQU 0X74 ;11,0VOLT 
SCHALT109   EQU 0X6E ;10,9VOLT     
SCHALT108   EQU 0X68 ;10,8VOLT 
SCHALT107   EQU 0X62 ;10,7VOLT     
SCHALT106   EQU 0X5C ;10,6VOLT 
SCHALT105   EQU 0X56 ;10,5VOLT
   
;BERECHNUNG
;ES GILT 0,1VOLT == 0X06 !!!
;ES GILT 13,0VOLT == 0X02EA (SIEHE OBEN)  
   
;DANN FUER 11,0VOLT 
;13VOLT-11Volt=2VOLT
;2,0VOLT:0,1VOLT= 20
;20 * DEZ 06 (AUS 0X06 FUER 0,1VOLT) = 120 (HEX 0X78)
;ES GILT :   
;0XEA(13,0V) - 0X78(2,0V) = 0x72(11,0V)  /// BEI 0x72 SCHALTET ES BEI 11,0VOLT
;HIER WURDE KORREGIERT DURCH PRAKTISCHES MESSEN MIT +0X02 == 0X74
   
;DANN IMMER 0,1VOLT(MINUS 0X06) SCHRITTWEISE WEITER BERECHNET FUER SCHALTSPANNUNGEN   
   
    
;HYSTERESE IMMER ADDIEREN MIT 0,1VOLT
HYST01     EQU 0X06    ;0,1VOLT ZUR SCHALT-SPANNUNG ADDIEREN   

    
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   
;MIT KORREKTUR NACH AUSPROBIEREN: 
;ES LEUCHTEN DIE LEDS:
;GRER 12,0V GN
;ZWISCHEN 12,0-11,7V GN + GE
;ZWISCHEN 11,7-11,4V GE    
;ZWISCHEN 11,4-11,2V GE + RT    
;KLEINER 11,2V RT

;BERECHNET FUER ==> 13,0V SIEHE OBEN    
;LED_H     EQU     0X02
;LED_L     EQU     0XEA  
;BEI 0,1VOLT WENIGER MINUS HEX= 0X06
   
;BERECHNET / SIEHE OBERHALB DAS PRINZIP
;LED_H     EQU     0X02  
LED_128    EQU     0XAE ;HIER 12,0VOLT
 
;LED_H     EQU     0X02 
LED_124    EQU     0X9C ;HIER 11,7VOLT

;LED_H     EQU     0X02 
LED_116    EQU     0X8A ;HIER 11,4VOLT

;LED_H     EQU     0X02 
LED_112    EQU     0X7E ;HIER 11,2VOLT
    
 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;ZEITEN NACH DENEN ES TOTAL ABSCHALTEN SOLL + RT-LED BLINKEN SOLL
;DAUERABSCHALTUNG MIT DER ZEIT IN MINUTEN     
ZEIT1       EQU D'1'
ZEIT3       EQU D'3'      
ZEIT5       EQU D'5'

MULT        EQU D'5'    ;AUS 200MSEC*5=> WERDEN 1SEC       
SECC        EQU D'60'   ;EQU D'60'  ;DA ES NUR 1SEC SIND BEI EINEM INTERRUPT    
 
 
 
;-----------------------------------------------------------------------------
;SPEICHERANFANG BZW. BEGINN

                ORG 0X0000
                GOTO MAIN               ; SPRUNG ZUM HAUPTPROGRAMM
                ORG 0X0004
                GOTO INTERRUPT

                ORG 0X0010
 ;*****************************************************************************
;*                              INTERRUPT-PROGRAMM                           *
;*                              19.09.05                                     *
;*****************************************************************************
INTERRUPT       PUSH
                BCF     T1CON, TMR1ON   ;TIMER1 ANHALTEN
                MOVLW   0X57            ;
                MOVWF   TMR1L           ;
                MOVLW   0X9E
                MOVWF   TMR1H
                BCF     PIR1, TMR1IF    ;OVERFLOW 0 MACHEN
                BSF     T1CON, TMR1ON   ;TIMER1 STARTEN

;FR 200MSEC BLINKEN                
                BTFSS   BLINK, BIT0     ;BLINKEN
                GOTO    Y1

                BCF     PORTA, BIT2 ;GN AUS
                BCF     PORTA, BIT3 ;GE AUS
                BSF     PORTA, BIT4 ;RT EIN
                BSF     PORTA, BIT6 ;PIEPSER EIN
                
                BCF     BLINK, BIT0
                GOTO    X0
                
Y1              BCF     PORTA, BIT2 ;GN AUS
                BCF     PORTA, BIT3 ;GE AUS
                BCF     PORTA, BIT4 ;RT AUS
                BCF     PORTA, BIT6 ;PIEPSER AUS
                
                BSF     BLINK, BIT0               
                
;FR 1/3/5MIN DAUERABSCHALTUNG                
X0              DECFSZ  MULTI, F
                GOTO    X1
                MOVLW   MULT
                MOVWF   MULTI
                
                DECFSZ  SEC, F          ;SEC  EQU D'...' MUSS OBEN REIN
                GOTO    X1
                MOVLW   SECC
                MOVWF   SEC
                
                DECFSZ  ZEIT, F
                GOTO    X1
                
                BSF     ZUSTAND, BIT2   ;ZEIT ERREICHT / ES BLINKT MIT DAUERABSCHALTUNG
                BCF     PORTA, BIT6     ;MOSFET AUS
                
X1              POP
                RETFIE
                
                
;*****************************************************************************
;*                              HAUPTPROGRAMM                                *
;*                              22.09.11                                     *
;*****************************************************************************
MAIN                       
                CLRF    PORTB
                CLRF    PORTA  
                

;----------- INIT ALLE PORT'S ----------------------------------------------------

                BANK1
                MOVLW   B'01101110'             ;0110-4MHZ INTERN-RC / 1-VOM SYSTEM / 1-STABILE FREQUENZ / 10-RC-TAKT-INTERN FUER SYSTEM
                MOVWF   OSCCON

                MOVLW   0X07                    ;COMPARATORS ALLE AUS VOM PORT A
                MOVWF   CMCON

                MOVLW   B'00100011'             ;INIT INPUT/OUTPUT AM PORTA 
                MOVWF   TRISA
                MOVLW   B'11111111'             ;INIT I/O PORTB  ALLES EINGNGE
                MOVWF   TRISB

;INIT TIMER 0 
                MOVLW   B'10000111'             ;BIT0-2 1=PRESCALER256, BIT3 0=TMR0, BIT4 0=ENTFAELLT, BIT5 0=TAKT VOM SYSTEM, BIT6 0=KEIN RB-INTERRUPT, BIT7 1=PULL-UPS DISABLE 
                MOVWF   OPTION_REG
                

;AD-INIT
                MOVLW   B'00000010' ; AN1         
                MOVWF   ANSEL
;AD-INIT
                MOVLW   B'10000000'  ;RECHTSBNDIG B1 / B0 / VSS+VDD-SPANNUNG B00
                MOVWF   ADCON1
                BANK0
;AD-INIT
                MOVLW   B'11001001'  ;FOSZ=RC B11 / AN1 B000 / GO-IST AUS + ON IST EIN B001
                MOVWF   ADCON0                
                

                
;INIT TIMER 1 
                MOVLW   B'00110000' ;BIT0 STOP-TIMER [0], BIT1 INTERNAL CLOCK [0], BIT2 EGAL [0], BIT3 OSZIL. OFF [0], BIT4-5 PRESCALER ALLES [11]1:8 VORERST 0
                MOVWF   T1CON

                BCF     PORTA, BIT7 ;MOSFET AUS
                BCF     PORTA, BIT2 ;GN AUS
                BCF     PORTA, BIT3 ;GE AUS
                BCF     PORTA, BIT4 ;RT AUS
                BCF     PORTA, BIT6 ;PIEPSER AUS
                
;ZEITSCHLEIFE 50MSEC                
                MOVLW   D'5'       ;5*10MSEC=50MSEC
                CALL    ZS10MSEC
                
;ABFRAGE RA0 JETZT NEUSTART
ANFANG02        ;BCF     ZUSTAND, BIT1
                ;BCF     ZUSTAND, BIT2
                CLRF    ZUSTAND
                GOTO    MESSEN_1
                
                
ANFANG01               
;VOREINSTELLUNG FR NORMALES SCHALTEN DES MOSFET (ALSO NICHT DIE HYSTERESE-SPANNUNG)
                        ;BCF     ZUSTAND, BIT0

;GN BLINKEN AUS MACHEN
                        ;BCF     ZUSTAND, BIT7

;GN BLINKEN AUS MACHEN
                        ;BCF     ZUSTAND, BIT1 
                        
;DAUER_AUS BEI HIGH / MOSFET AUS / ES BLINKT RT
                        ;BCF     ZUSTAND, BIT2
                        
;FR ALLES CLEAR                        
                        CLRF    ZUSTAND
                        CALL    INT_AUS                        
                        
;ZEITSCHLEIFE VON 50MSEC, MUSS SEIN WEGEN ANSCHALTEN, DANN ERST DIE ERSTEN BEFEHLE
ANFANG
                BCF     PORTA, BIT7 ;MOSFET AUS
                BCF     PORTA, BIT2 ;GN AUS
                BCF     PORTA, BIT3 ;GE AUS
                BCF     PORTA, BIT4 ;RT AUS
                BCF     PORTA, BIT6 ;PIEPSER AUS
                
;ZEITSCHLEIFE 50MSEC                
                ;MOVLW   D'5'       ;5*10MSEC=50MSEC
                ;CALL    ZS10MSEC
                
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MESSEN
                BTFSC   ZUSTAND, BIT2       ;BEI HIGH DAUERABSCHALTUNG
                GOTO    DAUER01
                
                BTFSS   ZUSTAND, BIT7       ;ES ERFOLGT AD-MESSUNG... BEI LOW
                GOTO    WEITER
                
                CALL    INT_AUS
                
MESSEN_1        BTFSS   ZUSTAND, BIT1     ;VON RA0-TASTER BIT1 AUF HIGH DANN BLINK GN VORRBER GEHEND 
                GOTO    MESSEN_2

MESSEN_3        BTFSS   PORTA, BIT0       ;RA0 TASTER LOSLASSEN
                GOTO    MESSEN_3
                
;ZEITSCHLEIFE 25MSEC/0,5SEC / ENTPRELLEN ALS KEINE STARRE ZEIT
TAST02          MOVLW   D'250' ;25MSEC
                MOVWF   HELP4
                MOVLW   D'20'  ;25MSEC*20=0,5SEC
                MOVWF   HELP5
                
TAST01          CALL    MUE100
                
                BTFSS   PORTA, BIT0
                GOTO    TAST02
                
                DECFSZ  HELP4, F
                GOTO    TAST01
                MOVLW   D'250'
                MOVWF   HELP4
                
                DECFSZ  HELP5, F
                GOTO    TAST01
                
                GOTO    ANFANG01
                
                
;GN BLINKEN ERFOLGT HIER /ABSCHALTUNG VORRBER GEHEND
MESSEN_2        BCF     PORTA, BIT7 ;MOSFET AUS
                BSF     PORTA, BIT2 ;GN AN
                BCF     PORTA, BIT3 ;GE AUS
                BCF     PORTA, BIT4 ;RT AUS
                BCF     PORTA, BIT6 ;PIEPSER AUS
             
                CALL    ZS500MSEC_TASTER
                BTFSC   ZUSTAND, BIT1
                GOTO    MESSEN_1
                
                BCF     PORTA, BIT7 ;MOSFET AUS
                BCF     PORTA, BIT2 ;GN AUS
                BCF     PORTA, BIT3 ;GE AUS
                BCF     PORTA, BIT4 ;RT AUS
                BCF     PORTA, BIT6 ;PIEPSER AUS

                MOVLW   D'4'                ;2SEC PAUSE NICHT LEUCHTEN
                MOVWF   HELP3
    
DA03            CALL    ZS500MSEC_TASTER
                BTFSC   ZUSTAND, BIT1
                GOTO    MESSEN_1
                
                DECFSZ  HELP3, F
                GOTO    DA03
                GOTO    MESSEN_1
                
;DAUER_AUS                
DAUER01         CALL    INT_AUS
                BCF     ZUSTAND, BIT1
                
DAUER02         BCF     PORTA, BIT7 ;MOSFET AUS
                BCF     PORTA, BIT2 ;GN AUS
                BCF     PORTA, BIT3 ;GE AUS
                BSF     PORTA, BIT4 ;RT AN
                BCF     PORTA, BIT6 ;PIEPSER AUS
                
                CALL    ZS200MSEC_TASTER
                BTFSC   ZUSTAND, BIT1               ;BEI HIGH BLINKEN AUS
                GOTO    DAUER04
                
                BCF     PORTA, BIT7 ;MOSFET AUS
                BCF     PORTA, BIT2 ;GN AUS
                BCF     PORTA, BIT3 ;GE AUS
                BCF     PORTA, BIT4 ;RT AUS
                BCF     PORTA, BIT6 ;PIEPSER AUS
                
                MOVLW   D'4'                ;2SEC PAUSE NICHT LEUCHTEN
                MOVWF   HELP3
                
DAUER03         CALL    ZS500MSEC_TASTER
                BTFSC   ZUSTAND, BIT1               ;BEI HIGH BLINKEN AUS
                GOTO    DAUER04
                
                DECFSZ  HELP3, F
                GOTO    DAUER03
                GOTO    DAUER02 

                
DAUER04                
                BTFSS   PORTA, BIT0       ;RA0 TASTER LOSLASSEN
                GOTO    DAUER04

                
;ZEITSCHLEIFE 25MSEC/0,5SEC / ENTPRELLEN ALS KEINE STARRE ZEIT
TAST12          MOVLW   D'250' ;25MSEC
                MOVWF   HELP4
                MOVLW   D'20'  ;25MSEC*20=0,5SEC
                MOVWF   HELP5
                
TAST11          CALL    MUE100
                
                BTFSS   PORTA, BIT0
                GOTO    TAST12
                
                DECFSZ  HELP4, F
                GOTO    TAST11
                MOVLW   D'250'
                MOVWF   HELP4
                
                DECFSZ  HELP5, F
                GOTO    TAST11
                
                GOTO    ANFANG02                

                

WEITER                
;ZEITSCHLEIFE JETZT JE MESSUNG 0,5SEC               
                MOVLW   D'50'        ;50*10MSEC=500MSEC=0,5SEC
                CALL    ZS10MSEC_TASTER
                                
                BTFSC   ZUSTAND, BIT7   ;ES IST WIEDER VORRBER GEHEND AUSGESCHALTET MIT BIT7 HIGH / GN BLINKT
                GOTO    MESSEN
                                
                CALL    AD

;AUSWERTEN DIE GEMESSENEN SPANNUNGEN AN AN1 VOM PIC
;ALSO WELCHE LED LEUCHTEN SOLL --> LADEZUSTANDSANZEIGE

;BEI AD_H HIGH-BYTE AUSWERTEN / SIEHE BERECHNUNG AN 10K UND 3,9K
                MOVLW   0X02                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                GOTO    MESS01
                
                MOVLW   0X03                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                CALL    NUR_GN

                MOVLW   0X01                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                CALL    NUR_RT
            
                MOVLW   0X00                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                CALL    NUR_RT
                    
                GOTO    MESS_MOSFET
                
MESS01
;GROESSER 12,8VOLT
                MOVLW   LED_128         
                SUBWF   AD_L, W         
                BTFSS   STATUS, C       ;C HIGH (1) BEI GROESSER GLEICH // C LOW (0) BEI KLEINER                
                GOTO    MESS02          ;KLEINER NACH   
                
                CALL    NUR_GN
                GOTO    MESS_MOSFET
                
MESS02
;ZWISCHEN 12,8VOLT UND 12,4VOLT
                MOVLW   LED_124         ;BEI GRSSER+GLEICH 12,4VOLT         
                SUBWF   AD_L, W         
                BTFSS   STATUS, C       ;C HIGH (1) BEI GROESSER GLEICH // C LOW (0) BEI KLEINER                
                GOTO    MESS03          ;KLEINER NACH   
                
                CALL    GN_GE
                GOTO    MESS_MOSFET
                
MESS03
;ZWISCHEN 12,4VOLT UND 11,6VOLT                
                MOVLW   LED_116         ;BEI GRSSER+GLEICH 11,6VOLT         
                SUBWF   AD_L, W         
                BTFSS   STATUS, C       ;C HIGH (1) BEI GROESSER GLEICH // C LOW (0) BEI KLEINER                
                GOTO    MESS04          ;KLEINER NACH   
                
                CALL    NUR_GE
                GOTO    MESS_MOSFET
                
MESS04
;ZWISCHEN 11,6VOLT UND 11,2VOLT                 
                MOVLW   LED_112         ;BEI GRSSER+GLEICH 11,2VOLT         
                SUBWF   AD_L, W         
                BTFSS   STATUS, C       ;C HIGH (1) BEI GROESSER GLEICH // C LOW (0) BEI KLEINER                
                GOTO    MESS05          ;KLEINER NACH   
                
                CALL    GE_RT
                GOTO    MESS_MOSFET                
                
MESS05
;KLEINER 11,2VOLT
                MOVLW   LED_112         ;BEI KLEINER 11,2VOLT         
                SUBWF   AD_L, W         
                BTFSC   STATUS, C       ;C HIGH (1) BEI GROESSER GLEICH // C LOW (0) BEI KLEINER                
                GOTO    MESS_MOSFET     ;GROESSER GEHT NICHT AN ANFANG ZUM MESSEN   
                
                CALL    NUR_RT
                ;GOTO    MESS_MOSFET
                
                
                
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;SCHALTEN DES MOSFETS NACH SPANNUNGEN...
MESS_MOSFET
;DIP-SCHALTER ABFRAGEN                  
                ;BTFSC   PORTA, BIT5 ;DIP1
                ;GOTO    DIP2
                ;MOVLW   SCHALT104
                ;GOTO    AUSWERTUNG

;DIP2
                BTFSC   PORTB, BIT0 ;DIP1
                GOTO    DIP3
                MOVLW   SCHALT105
                GOTO    AUSWERTUNG               

DIP3            BTFSC   PORTB, BIT1 ;DIP2
                GOTO    DIP4
                MOVLW   SCHALT106
                GOTO    AUSWERTUNG

DIP4            BTFSC   PORTB, BIT2 ;DIP3
                GOTO    DIP5
                MOVLW   SCHALT107
                GOTO    AUSWERTUNG               

DIP5            BTFSC   PORTB, BIT3 ;DIP4
                GOTO    DIP6
                MOVLW   SCHALT108
                GOTO    AUSWERTUNG

DIP6            BTFSC   PORTB, BIT4 ;DIP5
                GOTO    DIP7
                MOVLW   SCHALT109
                GOTO    AUSWERTUNG               

DIP7            BTFSC   PORTB, BIT5 ;DIP6
                GOTO    DIP_SCHLUSS 
                MOVLW   SCHALT110
                GOTO    AUSWERTUNG

;DIP8            BTFSC   PORTB, BIT6 ;DIP8
;                GOTO    DIP_SCHLUSS
;                MOVLW   SCHALT111
;                GOTO    AUSWERTUNG               
                                
DIP_SCHLUSS     MOVLW   SCHALT110       ;KEIN DIP-SCHALTER AUF LOW / ALLE HIGH
                
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;AUSWERTUNG OB MOSFET AN ODER AUS AN RA0
AUSWERTUNG
                MOVWF   SCHALT_AUS    ;SCHALTSPANNUNG DES MOSFET FR AUS SICHERN VON DIP-SCHALTERN
;HYSTERESE SPANNUNG BERECHNEN
                ADDLW   HYST01
                MOVWF   SCHALT_EIN    ;SCHALTSPANNUNG DES MOSFET FR WIEDER EIN SICHERN MIT HYSTERESE-SPANNUNG
                
;NUR BEI ZUSTAND SCHALTEN
                BTFSC   ZUSTAND, BIT0   ;BEI HIGH IST HHERE HYSTERESE-SPANNUNGS-ABFRAGE // BEI LOW NORMALES AUSSCHALTEN
                GOTO    HYSTE
                
                MOVLW   0X02                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                GOTO    AUSW2
   
                MOVLW   0X03                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                GOTO    AUSW1

                MOVLW   0X01                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                GOTO    AUSW3
            
                MOVLW   0X00                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                GOTO    AUSW3
                
                
                
                
AUSW2
                MOVF    SCHALT_AUS, W   ;         
                SUBWF   AD_L, W         
                BTFSC   STATUS, C       ;C HIGH (1) BEI GROESSER GLEICH // C LOW (0) BEI KLEINER                
                GOTO    AUSW1           ;GROESSER GEHT NICHT AN ANFANG ZUM MESSEN
                
;BEI KLEINER                
AUSW3                
                BSF     PORTA, BIT7 ;BCF     PORTA, BIT6     ;MOSFET MIT AUS SCHALTEN
                BSF     ZUSTAND, BIT0   ;MERKER FR --> ES HAT AUSGESCHALTET /// DANN WIEDER MIT HYSTERESE (SCHALT_EIN) EINSCHALTEN
                CALL    INT_EIN         ;ZEIT 0/1/3/5 STARTEN
                
                GOTO    MESSEN
                
;BEI GRSSER                
AUSW1            
                BSF     PORTA, BIT7     ;MOSFET MIT EIN SCHALTEN
                BCF     ZUSTAND, BIT0   ;MERKER FR --> ES HAT EINGESCHALTEN /// DANN WIEDER NORMALES MESSEN
                CALL    INT_AUS         ;ZEIT 0/1/3/5 AUS
                
                GOTO    MESSEN
                
;HIER MIT HYSTERESE-SPANNUNG WIEDER EIN-SCHALTEN
HYSTE            
                MOVLW   0X02                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                GOTO    HYS3
   
                MOVLW   0X03                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                GOTO    HYS2

                MOVLW   0X01                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                GOTO    HYS1
            
                MOVLW   0X00                ;BEI GLEICH
                SUBWF   AD_H, W
                BTFSC   STATUS, Z                
                GOTO    HYS1
                
HYS3                
                MOVF    SCHALT_EIN, W   ;         
                SUBWF   AD_L, W         
                BTFSS   STATUS, C       ;C HIGH (1) BEI GROESSER GLEICH // C LOW (0) BEI KLEINER                
                GOTO    HYS1  
                
;BEI GRSSER
HYS2            
                ;IMMER MESSEN ==JETZT WIEDER AN LEDS-DARSTELLEN / SCHNELL BLINKEN RT AUS MACHEN + ZEIT-INTERRUPT AUS == ALSO ALLE INTERRUPTE AUS
                BSF     PORTA, BIT7     ;MOSFET MIT WIEDER EIN SCHALTEN
                BCF     ZUSTAND, BIT0   ;MERKER FR --> ES HAT EINGESCHALTET 
                CALL    INT_AUS         ;ZEIT 0/1/3/5 AUS                             

                ;BCF     ZUSTAND, BIT7   ;BLINKEN AUSSCHALTEN 
                GOTO    MESSEN                
                
;BEI KLEINER                
HYS1
                ;IMMER MESSEN ==JETZT AN LEDS NICHT-DARSTELLEN / SCHNELL BLINKEN RT EIN MACHEN + ZEIT-INTERRUPT EIN == ALS 2X INTERRUPT EIN
                BSF     PORTA, BIT7    ;BCF     PORTA, BIT6     ;MOSFET AUS
                BSF     ZUSTAND, BIT0   ;MERKER FR --> ES HAT AUSGESCHALTET
                
                ;CALL    INT_EIN         ;ZEIT 0/1/3/5 STARTEN
                GOTO    MESSEN
                
 
                
                
                 
;*****************************************************************************
;*                              ZEIT-MESSUNG-AN                              *
;*****************************************************************************
INT_EIN
;DIP-SCHALTER ABFRAGEN
                CLRF    HELP1
                
                BTFSC   PORTB, BIT6 ;DIP9
                GOTO    DIP9
                MOVLW   0X02
                MOVWF   HELP1

DIP9            
                BTFSC   PORTB, BIT7 ;DIP10
                GOTO    BER01
                INCF    HELP1, F
                
BER01
                MOVLW   0X00                ;BEI GLEICH
                SUBWF   HELP1, W
                BTFSS   STATUS, Z                
                GOTO    BER02    
                
                
                BSF     ZUSTAND, BIT2   ;ZEIT ERREICHT / ES BLINKT MIT DAUERABSCHALTUNG
                BCF     PORTA, BIT7     ;MOSFET AUS
               
                RETURN

BER02                
                MOVLW   0X01                ;BEI GLEICH
                SUBWF   HELP1, W
                BTFSS   STATUS, Z                
                GOTO    BER03    
                
                MOVLW   ZEIT1
                MOVWF   ZEIT
                GOTO    INI_INTERRUPT
                
    
BER03                
                MOVLW   0X02                ;BEI GLEICH
                SUBWF   HELP1, W
                BTFSS   STATUS, Z                
                GOTO    BER04    
                
                MOVLW   ZEIT3
                MOVWF   ZEIT
                GOTO    INI_INTERRUPT
                
BER04                
                MOVLW   0X03                ;BEI GLEICH
                SUBWF   HELP1, W
                BTFSS   STATUS, Z                
                GOTO    INI_INTERRUPT   
                
                MOVLW   ZEIT5
                MOVWF   ZEIT
                
                
INI_INTERRUPT
                MOVLW   SECC
                MOVWF   SEC
                MOVLW   MULT
                MOVWF   MULTI
                BSF     BLINK, BIT0     ;BLINKEN MIT EIN RT BEGINNEN 
                BCF     AUS, BIT0       ;BEIM MESSEN LEDS AUS
                
                BCF     T1CON, TMR1ON   ;STOP TIMER1               
                BCF     PIR1, TMR1IF    ;OVERFLOW 0 MACHEN
            
                BSF     INTCON, GIE     ;ALLGEMEINES INTERRUPT ENABLE
                BSF     INTCON, PEIE    ;SIEHE BEI I_AUS /MUSS NICHT SEIN / DANN AUCH HIER WEG 
                                        ;/ ABER IM HAUPTPROGRAMM MUSS ES DANN EINGESCHALTET WERDEN !
            
                BANK1
                BSF     PIE1, TMR1IE    ;OVERFLOW INTERRUPT BEI TIMER1 ZULASSEN/ENABLE
                BANK0
                
;200MS/32=6,25MS/0.25S=25000TAKTE
;(0XFFFF) - 25000(0X61A8)=0X9E57                
                MOVLW   0X57
                MOVWF   TMR1L
                MOVLW   0X9E
                MOVWF   TMR1H

                BSF     T1CON, TMR1ON       ;START TIMER1

                RETURN
                
                
                
                                
;*****************************************************************************
;*                              ZEIT-MESSUNG-AUS INTERRUPT AUS               *
;*****************************************************************************
INT_AUS
                BCF     INTCON, GIE     ;INTERRUPT ABSCHALTEN SO WIE ES IM BUCH STEHT
                BTFSC   INTCON, GIE
                GOTO    INT_AUS
            
                BCF     INTCON, PEIE    ;MUSS NICHT UNBEDINGT AUS SEIN
                
                BSF     AUS, BIT0       ;LEDS AN
                
                RETURN                
 
;*****************************************************************************
;*                              AD-MESSUNG                                   *
;*****************************************************************************
AD              BCF     PIR1, ADIF 
                BSF     ADCON0, GO_DONE  ;GEHT LOS DIE MESSUNG
                CALL    MUE100

AD2             BTFSS   PIR1, ADIF
                GOTO    AD2

                BCF     ADCON0, GO_DONE  ;STOP DER MESSUNG

;AD-ERGEBNIS ABSPEICHERN IN RAM-ZELLEN AD_H UND AD_L
                MOVF    ADRESH, W
                MOVWF   AD_H
                BANK1                               
                MOVF    ADRESL, W
                BANK0                               
                MOVWF   AD_L

                RETURN
 
;*****************************************************************************
;*                              100S ZEITSCHLEIFE                           *
;*                              31.10.03                                     *
;*****************************************************************************

MUE100      MOVLW   D'10'   ;100SEC 
            MOVWF   HELP0
M1          NOP             ;10X NOP (1X T=4) ALSO T=40*0.25S=10SEC
            NOP         
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            NOP
            DECFSZ  HELP0, F
            GOTO    M1
            RETURN
               
;*****************************************************************************
;*         UNTERPROGRAMM MIT TIMER0 ALS ZEITSCHLEIFE FUER  10MSEC ....       *
;*                                                                           *
;*****************************************************************************
ZS10MSEC                MOVWF   HELP0                   ;DER INHALT VON W WIRD IN "HELP1" GELADEN

T01                     MOVLW   D'217'
                        MOVWF   TMR0                    ;DER FESTE RAM-SPEICHER (TMR0) WIRD MIT 217 GELADEN
                        BCF     INTCON, TMR0IF            ;OVERFLOW = 0
                
T02                     BTFSS   INTCON, TMR0IF            ;WENN DIE ZEIT VON 10MSEC ABGELAUFEN IST, WIRD T0IF HIGH (1) UND 
                        GOTO    T02                     ;ES ERFOLGT EIN SPRUNG ZU "DECFSC MERK, F"
                        
                        DECFSZ  HELP0, F                ;ES WIRD DER WERT IN "HELP1" ABWRTS GEZHLT, BIS ER (0) IST UND
                        GOTO    T01                     ;DANN ERFOLGT EIN SPRUNG ZU "RETURN"-ENDE DES UNTERPROGRAMMS
                        RETURN

;ZEITBERECHNUNG FUER 10MS
;PRESCALER 256X  *  SYSTEM 4X  * TAKTZEIT ====> 256*4*0.25SEC=256SEC          /DIE TAKTZEIT ERGIBT SICH AUS DEM INTERNEN OSZILLATOR
;10MS : 256SEC= 39                                                           /T = 1 : F  (F)-OSZILLATORFREQUENZ
;ALSO
;256S*D'39'=9,984MSEC
;TMR0 ALSO D'256'-D'39'=D'217' ENTSPRICHT CA. 10MSEC
;217 DEZIMAL OBEN EINTRAGEN
                        
;*****************************************************************************
;*         UNTERPROGRAMM MIT TIMER0 ALS ZEITSCHLEIFE FUER  1MSEC ....        *
;*                                                                           *
;*****************************************************************************
ZS10MSEC_TASTER         MOVWF   HELP0                   ;DER INHALT VON W WIRD IN "HELP1" GELADEN

T001                    MOVLW   D'217'
                        MOVWF   TMR0                    ;DER FESTE RAM-SPEICHER (TMR0) WIRD MIT 217 GELADEN
                        BCF     INTCON, TMR0IF            ;OVERFLOW = 0

                        
T0021          
                BTFSC   PORTA, BIT0       ;RA0 ABFRAGEN DAUER-ABSCHALTUNG EIN MIT TASTER
                GOTO    T002
                
T0022           BTFSS   PORTA, BIT0       ;RA0 TASTER LOSLASSEN
                GOTO    T0022
                
              
;ZEITSCHLEIFE 25MSEC/0,5SEC / ENTPRELLEN ALS KEINE STARRE ZEIT
TAST22          MOVLW   D'250' ;25MSEC
                MOVWF   HELP4
                MOVLW   D'20'  ;25MSEC*20=0,5SEC
                MOVWF   HELP5
                
TAST21          CALL    MUE100
                
                BTFSS   PORTA, BIT0
                GOTO    TAST22
                
                DECFSZ  HELP4, F
                GOTO    TAST21
                MOVLW   D'250'
                MOVWF   HELP4
                
                DECFSZ  HELP5, F
                GOTO    TAST21
 
                BSF     ZUSTAND, BIT7
                RETURN
                
                
T002                    BTFSS   INTCON, TMR0IF            ;WENN DIE ZEIT VON 10MSEC ABGELAUFEN IST, WIRD T0IF HIGH (1) UND 
                        GOTO    T0021                     ;ES ERFOLGT EIN SPRUNG ZU "DECFSC MERK, F"
                        
                        DECFSZ  HELP0, F                ;ES WIRD DER WERT IN "HELP1" ABWRTS GEZHLT, BIS ER (0) IST UND
                        GOTO    T001                    ;DANN ERFOLGT EIN SPRUNG ZU "RETURN"-ENDE DES UNTERPROGRAMMS
                        
                        RETURN
                        
;*****************************************************************************
;*         UNTERPROGRAMM MIT TIMER1 ALS ZEITSCHLEIFE FUER  0,5SEC            *
;*                                                                           *
;*****************************************************************************
ZS500MSEC_TASTER          

            BCF     T1CON, TMR1ON       ;STOP TIMER1            
            MOVLW   0XDC                ;500MS/32=15.625MS/0.25MYS=62500TAKTE
            MOVWF   TMR1L               ;0X10000-62500(0XF424)=0X0BDC  
            MOVLW   0X0B
            MOVWF   TMR1H
            BCF     PIR1, TMR1IF        ;OVERFLOW 0 MACHEN
            BSF     T1CON, TMR1ON       ;START TIMER1
            
ZS5001          
                BTFSC   PORTA, BIT0     ;RA0 ABFRAGEN DAUER-STOP-ABSCHALTUNG BEENDEN MIT TASTER
                GOTO    ZS500
                BSF     ZUSTAND, BIT1
                BCF     T1CON, TMR1ON       ;STOP TIMER1
                RETURN
                
ZS500       BTFSS   PIR1, TMR1IF
            GOTO    ZS5001
            BCF     T1CON, TMR1ON       ;STOP TIMER1 
            RETURN

                        
;*****************************************************************************
;*         UNTERPROGRAMM MIT TIMER1 ALS ZEITSCHLEIFE FUER  0,2SEC            *
;*                                                                           *
;*****************************************************************************
ZS200MSEC_TASTER          

            BCF     T1CON, TMR1ON       ;STOP TIMER1            
            MOVLW   0X57                ;200MS
            MOVWF   TMR1L               ;
            MOVLW   0X9E
            MOVWF   TMR1H
            BCF     PIR1, TMR1IF        ;OVERFLOW 0 MACHEN
            BSF     T1CON, TMR1ON       ;START TIMER1
            
ZS50012          
                BTFSC   PORTA, BIT0     ;RA0 ABFRAGEN DAUER-STOP-ABSCHALTUNG BEENDEN MIT TASTER
                GOTO    ZS5002
                BSF     ZUSTAND, BIT1
                BCF     T1CON, TMR1ON       ;STOP TIMER1
                RETURN
                
ZS5002      BTFSS   PIR1, TMR1IF
            GOTO    ZS50012
            BCF     T1CON, TMR1ON       ;STOP TIMER1 
            RETURN

                        
;*****************************************************************************
;*                              LED-ANZEIGE                                  *
;*****************************************************************************
NUR_RT
                BTFSS   AUS, BIT0
                RETURN
                
                BCF     PORTA, BIT2 ;GN AUS
                BCF     PORTA, BIT3 ;GE AUS
                BSF     PORTA, BIT4 ;RT EIN
                BCF     PORTA, BIT6 ;PIEPSER AUS
                RETURN

                
;*****************************************************************************
;*                              LED-ANZEIGE                                  *
;*****************************************************************************
NUR_GN
                BTFSS   AUS, BIT0
                RETURN
                
                BSF     PORTA, BIT2 ;GN EIN
                BCF     PORTA, BIT3 ;GE AUS
                BCF     PORTA, BIT4 ;RT AUS
                BCF     PORTA, BIT6 ;PIEPSER AUS
                RETURN
                
;*****************************************************************************
;*                              LED-ANZEIGE                                  *
;*****************************************************************************
NUR_GE
                BTFSS   AUS, BIT0
                RETURN
                
                BCF     PORTA, BIT2 ;GN AUS
                BSF     PORTA, BIT3 ;GE EIN
                BCF     PORTA, BIT4 ;RT AUS
                BCF     PORTA, BIT6 ;PIEPSER AUS
                RETURN

                
;*****************************************************************************
;*                              LED-ANZEIGE                                  *
;*****************************************************************************
GN_GE
                BTFSS   AUS, BIT0
                RETURN
                
                BSF     PORTA, BIT2 ;GN EIN
                BSF     PORTA, BIT3 ;GE EIN
                BCF     PORTA, BIT4 ;RT AUS
                BCF     PORTA, BIT6 ;PIEPSER AUS
                RETURN
                 
;*****************************************************************************
;*                              LED-ANZEIGE                                  *
;*****************************************************************************
GE_RT
                BTFSS   AUS, BIT0
                RETURN
                
                BCF     PORTA, BIT2 ;GN AUS
                BSF     PORTA, BIT3 ;GE EIN
                BSF     PORTA, BIT4 ;RT EIN
                BCF     PORTA, BIT6 ;PIEPSER AUS
                RETURN
                
                

                
                END

                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        